package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 大屏筛选过滤对象
 *
 * @author Administrator
 */
@Data
public class DPFilterParamDto {
    /**
     * 区域
     */
    @NotBlank(message = "区域编码不能为空！")
    private String cityCode;

    /**
     * 数据统计的开始日期
     */
    private String beginDate;

    /**
     * 数据统计的结束日期
     */
    private String endDate;

    /**
     * 业务类型0告知管理，1使用登记，2变更登记，3停用启用，4注销报废
     */
    private String businessKey;

    /**
     * 具体业务类型  例如：安装告知、维修告知等
     * code对应统计服务中的jgdp_businessType.json
     */
    private String businessTypeCode;

    /**
     * month , year
     */
    private String searchType;
    /**
     * 1生产单位 2使用单位 3充装单位 4检验机构 5检测机构
     */
    private String companyType;
    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String superviseUnitName;

    /**
     * 监管单位编码（接收单位/管辖机构）
     */
    private String superviseUnitCode;

    /**
     * 企业单位名称（发起单位/使用单位）
     */
    private String companyName;

    /**
     * 人员类型
     */
    private String newPost;
    /**
     * 姓名
     */
    private String name;
    /**
     * 证件号码
     */
    private String certificateNum;
    /**
     * 所在单位名称
     */
    private String unitName;
    /**
     * 设备种类code
     */
    private String equListCode;
    /**
     * 设备类别code
     */
    private String equCategoryCode;

    /**
     * 业务状态
     */
    private String status;

    private String equipType;

    private String phone;

    private String superviseKey;
    private List<String> region;
    private String regionStr;
    /**
     * 监管机构组织机构代码
     */
    private String superviseOrgCode;

    /**
     * 区域下的所有单位监管、行政审批（地市、区县级）
     */
    private List<String> companyCodes;
}
