package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 消防队伍
 *
 * @author tb
 * @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FireTeamDto", description = "消防队伍")
public class FireTeamDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "所属单位", index = 0)
    @ApiModelProperty(value = "机构名称")
    @ExplicitConstraint(indexNum = 0, sourceClass = CommonExplicitConstraint.class,method="getCompanyDetailTree") //动态下拉内容
    private String companyName;

    @ExcelIgnore
    @ApiModelProperty(value = "机构id")
    private Long company;

    @ExcelIgnore
    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ExplicitConstraint(indexNum = 1, sourceClass = CommonExplicitConstraint.class,method="getFireTeamList") //动态下拉内容
    @ExcelProperty(value = "上级队伍", index = 1)
    @ApiModelProperty(value = "父级名称")
    private String parentName;

    @ExcelIgnore
    @ApiModelProperty(value = "父级")
    private Long parent;

    @ExcelProperty(value = "队伍名称", index = 2)
    @ApiModelProperty(value = "单位名称")
    private String name;

    @ExplicitConstraint(type = "XFJGLX", indexNum = 3, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "队伍类型", index = 3)
    @ApiModelProperty(value = "消防队类型（专职消防队，监控大队）")
    private String type;

    @ExcelIgnore
    @ApiModelProperty(value = "队伍类型code")
    private String typeCode;

    @ExcelProperty(value = "队伍地址", index = 4)
    @ApiModelProperty(value = "队伍地址")
    private String address;

    @ExcelProperty(value = "地球经度", index = 5)
    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ExcelProperty(value = "地球纬度", index = 6)
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ExcelIgnore
    @ApiModelProperty(value = "联系人id")
    private Long contactUserId;

    @ExplicitConstraint(indexNum = 7, sourceClass = CommonExplicitConstraint.class,method = "getFireTeamContactUser") //动态下拉内容
    @ExcelProperty(value = "联系人", index = 7)
    @ApiModelProperty(value = "联系人")
    private String contactUser;

    @ExcelProperty(value = "联系电话", index = 8)
    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ExcelProperty(value = "职责_简要情况", index = 9)
    @ApiModelProperty(value = "职责_简要情况")
    private String obligation;

    @ExcelIgnore
    @ApiModelProperty(value = "消防队伍图片")
    private String img;

    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "执勤车辆数")
    private String onDutyCount;

    @ExcelIgnore
    @ApiModelProperty(value = "出动车辆数")
    private String outCount;

    @ExcelIgnore
    @ApiModelProperty(value = "队伍下车辆")
    private List<FireBrigadeResourceDto> children;
}