package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum IsIntoManagementEnum {
    FALSE("未纳管", false),
    TRUE("已纳管", true);

    private final String name;
    private final boolean code;

    private static final Map<Boolean, String> CODE_NAME_MAP = Arrays.stream(values())
            .collect(Collectors.toMap(IsIntoManagementEnum::isCode, IsIntoManagementEnum::getName));

    /**
     * 根据 code获取枚举对应的 name
     */
    public static String getName(boolean code) {
        return CODE_NAME_MAP.get(code);
    }
}

