package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgCertificateReplenishDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgCertificateReplenish;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateReplenishServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateReplenishServiceImpl.*;

/**
 * @author system_generator
 * @date 2025-03-19
 */
@RestController
@Api(tags = "补证申请登记")
@RequiredArgsConstructor
@RequestMapping(value = "/jg-certificate-replenish")
public class JgCertificateReplenishController extends BaseController {

    private final JgCertificateReplenishServiceImpl jgCertificateReplenishServiceImpl;


    /**
     * 根据证的sequenceNbr 批量查询证下面的所有设备
     *
     * @param sequenceNbr 证的sequenceNbr
     * @return 证下的所有设备
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryEquByCertificateSeqList")
    @ApiOperation(httpMethod = "GET", value = "根据证的sequenceNbr 批量查询证下面的所有设备", notes = "根据证的sequenceNbr 批量查询证下面的所有设备")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Map<String, Object>> queryEquByCertificateSeqList(@RequestParam(value = "record") String sequenceNbr) {
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.queryEquByCertSeq(sequenceNbr));
    }

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<List<JgCertificateReplenish>> save(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.save(jsonObject));
    }

    /**
     * 更新
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/update")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr更新补证登记单", notes = "根据sequenceNbr更新补证登记单")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> updateBySequenceNbr(@RequestParam("submitType") String submitType,
                                                     @RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.updateCertRep("0".equals(submitType) ? UPDDATE_NOT_SUBMIT : UPDDATE_SUBMIT, jsonObject));
    }

    /**
     * 受理
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accept")
    @ApiOperation(httpMethod = "POST", value = "补证登记受理", notes = "补证登记受理")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgEquipTransferDto> accept(@RequestParam(value = "operate") String operate, @RequestBody Map<String, Object> map) {
        JSONObject model = JSON.parseObject(JSON.toJSONString(map.get(MODEL)));
        model.put(PROCESS_ADVICE, map.get(PROCESS_ADVICE));
        jgCertificateReplenishServiceImpl.accept("0".equals(operate) ? APPROVED : REJECTED, model);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Page<JgCertificateReplenish>> queryForPage(JgCertificateReplenishDto dto,
                                                                    @ApiParam(value = "当前页码", required = true) @RequestParam(value = "current", defaultValue = "1") int current,
                                                                    @ApiParam(value = "每页大小", required = true) @RequestParam(value = "size", defaultValue = "20") int size,
                                                                    @ApiParam(value = "排序字段",required = false) @RequestParam(value = "sort",required = false) String sort,
                                                                    @ApiParam(value = "客户端类型: jgAudit-监管审核;jgLook-监管查看") @RequestParam(value = "client", required = false, defaultValue = "jgAudit") String client
                                                                    ) {
        Page<JgCertificateReplenish> page = new Page<JgCertificateReplenish>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.queryForJgCertificateReplenishPage(page, dto, sort, client));
    }

    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgCertificateReplenishDto> cancel(@RequestBody JgCertificateReplenishDto dto) {
        jgCertificateReplenishServiceImpl.cancel(dto);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单据", notes = "根据sequenceNbr查询单据")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgCertificateReplenishServiceImpl.removeCertRepBySequenceNbr(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "补证登记作废", notes = "补证登记作废")
    @PutMapping(value = "/void")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgCertificateReplenish> voidApplication(@RequestBody JgCertificateReplenishDto certDto) {
        JgCertificateReplenish result = jgCertificateReplenishServiceImpl.voidApplication(certDto.getSequenceNbr(), certDto.getCancelReason());
        return ResponseHelper.buildResponse(result);
    }
}
