package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum DPStatusEnum {

    EQUIP_STATUS_USE("equipUse", "在用","在用", "", "success"),
    EQUIP_STATUS_STOP("equipStop", "停用","停用", "", "error"),
    EQUIP_STATUS_LOGOUT("equipLogout", "注销","注销", "", "error"),
    EQUIP_STATUS_SCRAP("equipScrap", "报废","报废", "", "error"),
    EQUIP_EMPHASIS_MONITOR("equipEmphasis", "重点监控设备","重点监控设备", "", "success"),
    USE_YEAR_GT_15("gt15", ">15年","使用年限大于15年", "", "error"),

    // 单位类型
    COMPANY_SY("sy", "使用单位","使用单位", "", "success"),
    COMPANY_CZ("cz", "充装单位","充装单位", "", "success"),
    COMPANY_JYJC("jyjc", "检验检测机构","检验检测机构", "", "success"),
    COMPANY_ZZ("zz", "制造单位","制造单位", "", "success"),
    COMPANY_SJ("sj", "设计单位","设计单位", "", "success"),
    COMPANY_AZGZWX("azgzwx", "安装改造维修单位","安装改造维修单位", "", "success"),

    MANAGE_STATUS_USE("manageUse", "在业","在业", "", "success"),
    MANAGE_STATUS_OPEN("manageOpen", "在业","开业", "", "success"),
    MANAGE_STATUS_STOP("manageStop", "停业","停业", "", "error"),
    COMPANY_EMPHASIS_MONITOR("emphasisMonitorCompany", "重点监控企业","重点监控企业", "", "success"),
    COMPANY_HIGH_RISK("highRisk", "高风险企业","高风险企业", "", "stop"),

    EQUIP_DATA_QUALITY_SCORE_1("1", "一类","一类", "", "success"),
    EQUIP_DATA_QUALITY_SCORE_2("2", "二类","二类", "", "success"),
    EQUIP_DATA_QUALITY_SCORE_3("3", "三类","三类", "", "success");

    private String key;
    private String label;
    private String status;
    private String icon;
    private String value;

    public static DPStatusEnum getEnumByStatus(String status) {
        for (DPStatusEnum c : DPStatusEnum.values()) {
            if (c.getStatus().equals(status)){
                return c;
            }
        }
        return null;
    }

    public static DPStatusEnum getEnumByKey(String key) {
        for (DPStatusEnum c : DPStatusEnum.values()) {
            if (c.getKey().equals(key)){
                return c;
            }
        }
        return null;
    }

    public static Map toMap(DPStatusEnum dpStatusEnum) {
        Map map = new HashMap<>();
        map.put("key", dpStatusEnum.getKey());
        map.put("label", dpStatusEnum.getLabel());
        map.put("status", dpStatusEnum.getStatus());
        map.put("icon", dpStatusEnum.getIcon());
        map.put("value", dpStatusEnum.getValue());
        return map;
    }
}
