package com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZBGLImpl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.mapper.JGStatisticsMapper;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZBGLStatisticsMapper;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class YwblpjsxtjServiceImpl implements IZBGLService {
    @Resource
    private StCommonServiceImpl stCommonService;
    @Resource
    private JGStatisticsMapper jgStatisticsMapper;
    @Override
    public Map<String, Object> getChart(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        String orgCodeP = stCommonService.getAndSetOrgCode(dpFilterParamForDetailDto.getCityCode());
        DPFilterParamDto dpFilterParamDto = new DPFilterParamDto();
        //安装告知、维修告知、改造告知、移装告知
        List<CountDto> noticCount = jgStatisticsMapper.queryNoticeAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //使用登记、车用气瓶使用登记
        List<CountDto> useCount = jgStatisticsMapper.queryUseAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //更名变更登记、改造变更登记、移装变更登记、单位变更登记、气瓶单位变更登记
        List<CountDto> changeCount = jgStatisticsMapper.queryChangeAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //启用停用
        List<CountDto> disableCount = jgStatisticsMapper.queryDisableAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //注销报废
        List<CountDto> cancelCount = jgStatisticsMapper.queryCancelAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);

        Map<String,Object> returnMap = new HashMap<>();
        List<Map<String,Object>> legendData = new ArrayList<>();
        for(int i = 0;i<5; i++){
            Map<String,Object> map = new HashMap<>();
            if(i == 0){
                map.put("dataKey","notic");
                map.put("value","告知管理");
                map.put("chartType","bar");
            }else if(i == 1){
                map.put("dataKey","use");
                map.put("value","使用登记");
                map.put("chartType","bar");
            }else if(i == 2){
                map.put("dataKey","change");
                map.put("value","变更登记");
                map.put("chartType","bar");
            }else if(i == 3){
                map.put("dataKey","disable");
                map.put("value","停用启用");
                map.put("chartType","bar");
            }else{
                map.put("dataKey","cancel");
                map.put("value","注销报废");
                map.put("chartType","bar");
            }
            legendData.add(map);
        }
        returnMap.put("legendData",legendData);

        List xdata = new ArrayList();
        List notic = new ArrayList();
        List use = new ArrayList();
        List change = new ArrayList();
        List disable = new ArrayList();
        List cancel = new ArrayList();

        regionModels.forEach(r -> {
            xdata.add(r.getRegionName());
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode().toString());
            notic.add(this.avgAndSumDealDate(noticCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            use.add(this.avgAndSumDealDate(useCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            change.add(this.avgAndSumDealDate(changeCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            disable.add(this.avgAndSumDealDate(disableCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            cancel.add(this.avgAndSumDealDate(cancelCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
        });

        returnMap.put("xdata",xdata);
        returnMap.put("notic",notic);
        returnMap.put("use",use);
        returnMap.put("change",change);
        returnMap.put("disable",disable);
        returnMap.put("cancel",cancel);
        return returnMap;
    }

    @Override
    public Page<Map<String, Object>> getPage(Page page,DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        String orgCodeP = stCommonService.getAndSetOrgCode(dpFilterParamForDetailDto.getCityCode());
        DPFilterParamDto dpFilterParamDto = new DPFilterParamDto();
        //安装告知、维修告知、改造告知、移装告知
        List<CountDto> noticCount = jgStatisticsMapper.queryNoticeAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //使用登记、车用气瓶使用登记
        List<CountDto> useCount = jgStatisticsMapper.queryUseAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //更名变更登记、改造变更登记、移装变更登记、单位变更登记、气瓶单位变更登记
        List<CountDto> changeCount = jgStatisticsMapper.queryChangeAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //启用停用
        List<CountDto> disableCount = jgStatisticsMapper.queryDisableAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        //注销报废
        List<CountDto> cancelCount = jgStatisticsMapper.queryCancelAvgDayByReceiveCompany(dpFilterParamDto, orgCodeP);
        List list = new ArrayList();
        regionModels.forEach(r -> {
            Map<String,Object> map = new HashMap<>();
            map.put("regionName",r.getRegionName());
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode().toString());
            map.put("notic",this.avgAndSumDealDate(noticCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            map.put("use",this.avgAndSumDealDate(useCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            map.put("change",this.avgAndSumDealDate(changeCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            map.put("disable",this.avgAndSumDealDate(disableCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            map.put("cancel",this.avgAndSumDealDate(cancelCount.stream().filter(c -> c.getKeyStr().contains(orgCode)).collect(Collectors.toList())));
            list.add(map);
        });
        page.setRecords(list);
        page.setTotal(list.size());
        return page;
    }

    @Override
    public List<Map<String, String>> getTitle(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<Map<String, String>> list = new ArrayList<>();
        for(int i = 0; i < 6; i++){
            Map<String,String> map = new HashMap<>();
            if(i == 0){
                map.put("dataIndex","regionName");
                map.put("title","区域");
            }else if(i == 1){
                map.put("dataIndex","notic");
                map.put("title","告知管理");
            }else if(i == 2){
                map.put("dataIndex","use");
                map.put("title","使用登记");
            }else if(i == 3){
                map.put("dataIndex","change");
                map.put("title","变更登记");
            }else if(i == 4){
                map.put("dataIndex","disable");
                map.put("title","停用启用");
            }else if(i == 5){
                map.put("dataIndex","cancel");
                map.put("title","注销报废");
            }
            list.add(map);
        }

        return list;
    }

    private String avgAndSumDealDate(List<CountDto> collect) {
        BigDecimal sum = collect.stream().map(c -> new BigDecimal(c.getStrValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if(collect.isEmpty()){
            return "0";
        }
        return sum.divide(BigDecimal.valueOf(collect.size()), 1, RoundingMode.HALF_UP).toPlainString();
    }
}
