package com.yeejoin.amos.boot.module.tcm.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 使用单位
 *
 * @author duanwei
 * @date 2022-09-08
 */
@Data
@Accessors(chain = true)
@ApiModel(value="SpeUseUnit对象", description="使用单位")
public class SpeUseUnitDto implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    private String cerCode;

    @ApiModelProperty(value = "单位性质")
    private String unitNature;

    @ApiModelProperty(value = "营业执照图片")
    private String cerImgUrl;

    @ApiModelProperty(value = "营业执照登记机关")
    private String cerRegiOrg;

    @ApiModelProperty(value = "注册地址_省")
    private String cerAddrProvince;

    @ApiModelProperty(value = "注册地址_市")
    private String cerAddrCity;

    @ApiModelProperty(value = "注册地址")
    private String cerAddrArea;

    @ApiModelProperty(value = "注册大厦（小区）")
    private String cerAddrVillage;

    @ApiModelProperty(value = "注册地址_街道")
    private String cerAddrStreet;

    @ApiModelProperty(value = "注册地址_详细地址")
    private String cerAddrDetail;

    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    @ApiModelProperty(value = "法人手机")
    private String legalPersonPhone;

    @ApiModelProperty(value = "负责人")
    private String responPerson;

    @ApiModelProperty(value = "负责人手机")
    private String responPersonPhone;

    @ApiModelProperty(value = "所在地邮政编码")
    private String zipCode;

    @ApiModelProperty(value = "办公地址_省")
    private String offiAddrProvince;

    @ApiModelProperty(value = "办公地址_市")
    private String offiAddrCity;

    @ApiModelProperty(value = "办公地址")
    private String offiAddrArea;

    @ApiModelProperty(value = "办公地址_街道")
    private String offiAddrStreet;

    @ApiModelProperty(value = "办公大厦（小区）")
    private String offiAddrVillage;

    @ApiModelProperty(value = "办公地址_详细地址")
    private String offiAddrDetail;

    @ApiModelProperty(value = "冻结原因")
    private String frozenReason;

    @ApiModelProperty(value = "单位所属行业")
    private String industry;

    @ApiModelProperty(value = "值班电话")
    private String onDutyPhone;

    @ApiModelProperty(value = "管辖分局ID")
    private String auditOrgId;

    @ApiModelProperty(value = "管辖分局")
    private String auditOrgName;

    @ApiModelProperty(value = "管辖分局编码")
    private String auditOrgCode;

    @ApiModelProperty(value = "单位状态")
    private Integer status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "删除状态")
    private Integer delFlag;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "组织机构ID")
    private String sysOrgId;

    @ApiModelProperty(value = "所属组织机构编码")
    private String sysOrgCode;

    @ApiModelProperty(value = "96333救援电话")
    private String rescueCall;

    @ApiModelProperty(value = "同步id")
    private String syncId;


}
