package com.yeejoin.amos.boot.biz.common.annotation;


import java.lang.annotation.*;


@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface FieldDisplayDefine {

    String value();

    /**
     * 字段别名 兼容前端使用
     *
     * @return 别名key
     */
    String alias() default "";

    Class<?> type() default String.class;

    String format() default "yyyy-MM-dd";

    /**
     * 是否是数据库字典
     *
     * @return 是否
     */
    boolean isExist() default true;

    /**
     * 处理器bean 名称
     *
     * @return bean 名称唯一
     */
    String typeHandler() default "defaultTypeHandler";

    /**
     * 字典 key
     *
     * @return 字典key
     */
    String dictCode() default "";

    /**
     * 字典类型
     *
     * @return 平台字典、还是业务字典
     */
    DictType dictType() default DictType.no;

    /**
     * 是否冗余字段，如行政区划名称，冗余时则该字段不再记录变更日志
     *
     * @return 是否冗余
     */
    boolean isRepeatColumn() default false;

    enum DictType {
        /**
         * 业务字典
         */
        cb,
        /**
         * 平台字典
         */
        platform,
        /**
         * 非字典
         */
        no
    }
}
