package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.OtherInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.MidEquipOtherInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipOtherInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-其他信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class OtherInfoService extends AppBaseService<OtherInfoModel, MidEquipOtherInfo, MidEquipOtherInfoMapper> {

    /**
     *
     * 新增其他信息
     *
     * @param model 其他信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveOtherInfo(List<MidEquipOtherInfo> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("其他信息为空.");
        }

        for (MidEquipOtherInfo models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(OtherInfo models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
