package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-起重机械
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipTechParamLiftingDto", description="安全追溯-起重机械Dto")
public class EquipTechParamLiftingModel extends BaseDto {
    private static final long serialVersionUID = 1L;
    

            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "额定起重量")
        private BigDecimal ratedLiftingCapacity;
            @ApiModelProperty(value = "最大起重量")
        private BigDecimal maxLiftingCapacity;
            @ApiModelProperty(value = "最大起重力矩")
        private BigDecimal maxLiftingTorque;
            @ApiModelProperty(value = "跨度（工作幅度）")
        private BigDecimal spanWorkingRange;
            @ApiModelProperty(value = "起升速度")
        private BigDecimal liftingSpeed;
            @ApiModelProperty(value = "起升高度")
        private BigDecimal liftingHeight;
            @ApiModelProperty(value = "下降速度")
        private BigDecimal descentSpeed;
            @ApiModelProperty(value = "变幅高度")
        private BigDecimal luffingHeight;
            @ApiModelProperty(value = "回转速度")
        private BigDecimal slewingSpeed;
            @ApiModelProperty(value = "高度")
        private BigDecimal height;
            @ApiModelProperty(value = "工作级别")
        private String workLevel;
            @ApiModelProperty(value = "额定起重力矩")
        private BigDecimal ratedLiftingTorque;
            @ApiModelProperty(value = "最大起升高度")
        private BigDecimal maxiLiftingHeight;
            @ApiModelProperty(value = "最大工作幅度")
        private BigDecimal maxWorkRange;
            @ApiModelProperty(value = "最大工作幅度对应的起重量")
        private BigDecimal maxWokRangeWeight;
            @ApiModelProperty(value = "最大附着高度")
        private BigDecimal maxAttachmentHeight;
            @ApiModelProperty(value = "最大计算轮压")
        private BigDecimal maxCalculatedPressure;
            @ApiModelProperty(value = "整机设计重量")
        private BigDecimal machineDesignWeight;
            @ApiModelProperty(value = "运行轨距")
        private BigDecimal runGauge;
            @ApiModelProperty(value = "整机功率")
        private BigDecimal overallPower;
            @ApiModelProperty(value = "供电电源")
        private BigDecimal powerSupply;
            @ApiModelProperty(value = "工作环境温度")
        private BigDecimal workAmbientTemperature;
            @ApiModelProperty(value = "层数/泊位数")
        private Integer numberStorey;
            @ApiModelProperty(value = "主体结构型式")
        private String mainStructureType;
            @ApiModelProperty(value = "主要受力结构件材料")
        private String mainStressedStructuralMaterial;
            @ApiModelProperty(value = "变幅方式")
        private String luffingMode;
            @ApiModelProperty(value = "塔身标准节型式")
        private String towerStandardType;
            @ApiModelProperty(value = "基座型式")
        private String baseType;
            @ApiModelProperty(value = "大车运行速度")
        private BigDecimal bigcarRunSpeed;
            @ApiModelProperty(value = "小车运行速度")
        private BigDecimal smallcarrunSpeed;
            @ApiModelProperty(value = "大车基距")
        private BigDecimal bigcarBaseDistance;
            @ApiModelProperty(value = "小车轨距")
        private BigDecimal smallcarBaseDistance;
            @ApiModelProperty(value = "主钩左右极限位置")
        private BigDecimal mainHookLeftAndRightLimitPositions;
            @ApiModelProperty(value = "主梁型式")
        private String mainBeamType;
            @ApiModelProperty(value = "支腿型式")
        private String outriggerType;
            @ApiModelProperty(value = "最小工作幅度")
        private BigDecimal minWorkRange;
            @ApiModelProperty(value = "最小幅度起重量")
        private BigDecimal minLiftingCapacity;
            @ApiModelProperty(value = "全程变幅时间")
        private BigDecimal fullRangeLuffingTime;
            @ApiModelProperty(value = "行走机械轨距")
        private BigDecimal travelMachineGauge;
            @ApiModelProperty(value = "行驶速度")
        private BigDecimal travelSpeed;
            @ApiModelProperty(value = "支腿调节长度")
        private BigDecimal legAdjustmentLength;
            @ApiModelProperty(value = "发动机型号/VIN代号/编号")
        private String engineModel;
            @ApiModelProperty(value = "臂架型式")
        private String boomType;
            @ApiModelProperty(value = "起升高度(轨上)")
        private BigDecimal liftingHeightOnRail;
            @ApiModelProperty(value = "起升高度(轨下)")
        private BigDecimal liftingHeightUnderRail;
            @ApiModelProperty(value = "整机最大高度")
        private BigDecimal machineMaxHeight;
            @ApiModelProperty(value = "用途")
        private String use;
            @ApiModelProperty(value = "臂架结构型式")
        private String boomStructureType;
            @ApiModelProperty(value = "门架结构型式")
        private String gantryStructureType;
            @ApiModelProperty(value = "额定载重量")
        private BigDecimal ratedLoadCapacity;
            @ApiModelProperty(value = "额定成员数")
        private Integer ratedMembers;
            @ApiModelProperty(value = "额定提升速度")
        private BigDecimal ratedLiftingSpeed;
            @ApiModelProperty(value = "自由端高度")
        private BigDecimal heightFreeEnd;
            @ApiModelProperty(value = "最大提升高度")
        private BigDecimal maximumLiftingHeight;
            @ApiModelProperty(value = "吊笼工作行程")
        private BigDecimal workStrokeCage;
            @ApiModelProperty(value = "吊笼尺寸(长×宽×高)")
        private BigDecimal cageSize;
            @ApiModelProperty(value = "标准节尺寸(长×宽×高)")
        private BigDecimal standardSectionSize;
            @ApiModelProperty(value = "操纵方式")
        private String controlMode;
            @ApiModelProperty(value = "驱动机构型式")
        private String driveMechanismType;
            @ApiModelProperty(value = "标准节加节方式")
        private String standardSectionAddMethod;
            @ApiModelProperty(value = "存容量")
        private Integer storageCapacity;
            @ApiModelProperty(value = "起升驱动方式")
        private String liftingDriveMode;
            @ApiModelProperty(value = "适停车辆尺寸 (长×宽×高)")
        private BigDecimal parkingVehicleSize;
            @ApiModelProperty(value = "额定升降速度")
        private BigDecimal ratedLiftSpeed;
            @ApiModelProperty(value = "额定横移速度")
        private BigDecimal ratedTraverseSpeed;
            @ApiModelProperty(value = "额定纵移速度")
        private BigDecimal ratedLongitudinalSpeed;
            @ApiModelProperty(value = "单车最大进(出)车时间")
        private BigDecimal bicycleMaxExitTime;
            @ApiModelProperty(value = "循环速度")
        private BigDecimal cycleSpeed;
            @ApiModelProperty(value = "适停车辆质量")
        private BigDecimal parkingVehicleMass;
            @ApiModelProperty(value = "层高")
        private BigDecimal storeyHeight;
            @ApiModelProperty(value = "操作方式")
        private String operationMode;
            @ApiModelProperty(value = "其 他")
        private String other;
            @ApiModelProperty(value = "起升方式")
        private String liftingMode;
            @ApiModelProperty(value = "最大轮压")
        private BigDecimal maxPressure;
            @ApiModelProperty(value = "下降深度")
        private BigDecimal depthDescent;
            @ApiModelProperty(value = "防爆等级")
        private String explosionProofGrade;
            @ApiModelProperty(value = "防爆型式")
        private String explosionProofType;
            @ApiModelProperty(value = "吊具型式")
        private String slingType;
            @ApiModelProperty(value = "主要受力机构件材料")
        private String mainStressedMechanism;
            @ApiModelProperty(value = "起升机构起升速度倍率")
        private BigDecimal hoistLiftingMechanismSpeed;
            @ApiModelProperty(value = "起升机构起升速度")
        private BigDecimal hoistLiftingSpeedLifting;
            @ApiModelProperty(value = "起升机构起升速度相应最大起重量")
        private BigDecimal hoistLiftingCorrespondingMaxWeight;
            @ApiModelProperty(value = "起升机构电机型号")
        private String hoistMotorModel;
            @ApiModelProperty(value = "起升机构电机数量")
        private Integer hoistMotorsNumber;
            @ApiModelProperty(value = "起升机构功率")
        private BigDecimal hoistPower;
            @ApiModelProperty(value = "起升机构制动器型号")
        private String hoistBrakeModel;
            @ApiModelProperty(value = "起升机构制动器数量")
        private Integer hoistBrakesBrakes;
            @ApiModelProperty(value = "起升机构工作级别")
        private String hoistWorkingLevel;
            @ApiModelProperty(value = "起升机构卷筒直径")
        private BigDecimal hoistDrumDiameter;
            @ApiModelProperty(value = "起升机构定滑轮直径")
        private BigDecimal hoistFixedPulleyDiameter;
            @ApiModelProperty(value = "起升机构传动比")
        private String hoistTransmissionRatio;
            @ApiModelProperty(value = "起升机构大车轮直径")
        private BigDecimal hoistBigcarDiameter;
            @ApiModelProperty(value = "起升机构小车轮直径")
        private BigDecimal hoistSmallcarDiameter;
            @ApiModelProperty(value = "大车行走机构速度")
        private BigDecimal bigcarTraveSpeed;
            @ApiModelProperty(value = "大车行走机构功率")
        private BigDecimal bigcarTravePower;
            @ApiModelProperty(value = "大车行走机构工作级别")
        private String bigcarTraveWorkingLevel;
            @ApiModelProperty(value = "大车行走机构减速器型号")
        private String bigcarTraveReducerModel;
            @ApiModelProperty(value = "大车行走机构传动比")
        private String bigcarTraveTransmissionRatio;
            @ApiModelProperty(value = "大车行走机构制动力矩")
        private BigDecimal bigcarTraveBrakTorque;
            @ApiModelProperty(value = "大车行走机构大车车轮路面直径")
        private BigDecimal bigcarTraveRoadDiameter;
            @ApiModelProperty(value = "大车行走机构适应轨道")
        private String bigTraveAdaptTrack;
            @ApiModelProperty(value = "大车行走机构电机型号")
        private String bigcarTraveMotorModel;
            @ApiModelProperty(value = "大车行走机构电机数量")
        private Integer bigcarTraveMotorQuantity;
            @ApiModelProperty(value = "大车行走机构制动器型号")
        private String bigcarTraveControlBrakeModel;
            @ApiModelProperty(value = "大车行走机构制动器数量")
        private Integer bigcarTraveBrakeNumber;
            @ApiModelProperty(value = "小车行走机构速度")
        private BigDecimal smallcarTraveSpeed;
            @ApiModelProperty(value = "小车行走机构功率")
        private BigDecimal smallcarTravePower;
            @ApiModelProperty(value = "小车行走机构转速")
        private BigDecimal smallcarTraveRevolveSpeed;
            @ApiModelProperty(value = "小车行走机构工作级别")
        private String smallcarTraveWorkingLevel;
            @ApiModelProperty(value = "小车行走机构减速器型号")
        private String smallcarTraveReducerModel;
            @ApiModelProperty(value = "小车行走机构传动比")
        private String smallcarTraveTransmissionRatio;
            @ApiModelProperty(value = "小车行走机构制动力矩")
        private BigDecimal smallcarTraveBrakTorque;
            @ApiModelProperty(value = "小车行走机构小车车轮路面直径")
        private BigDecimal smallcarTraveRoadDiameter;
            @ApiModelProperty(value = "小车行走机构小车轨道")
        private String smallcarTraveTrolleyTrack;
            @ApiModelProperty(value = "小车行走机构电机型号")
        private String smallcarTraveMotorModel;
            @ApiModelProperty(value = "小车行走机构电机数量")
        private Integer smallcarTraveMotorQuantity;
            @ApiModelProperty(value = "小车行走机构制动器型号")
        private String smallcarTraveControlBrakeModel;
            @ApiModelProperty(value = "小车行走机构制动器数量")
        private Integer smallcarTraveBrakeNumber;
            @ApiModelProperty(value = "电源电压")
        private BigDecimal supplyVoltage;
            @ApiModelProperty(value = "电源频率")
        private BigDecimal powerFrequency;
            @ApiModelProperty(value = "非工作风压")
        private BigDecimal noWorkWindPresssure;
            @ApiModelProperty(value = "工作风压")
        private BigDecimal workWindPresssure;
            @ApiModelProperty(value = "环境温度")
        private BigDecimal ambientTemperature;
            @ApiModelProperty(value = "吊钩部位辐射温度")
        private BigDecimal radiationTemperatureOfHook;
            @ApiModelProperty(value = "梁架跨度")
        private BigDecimal beamFrameSpan;
            @ApiModelProperty(value = "桥机跨度")
        private BigDecimal bridgeCraneSpan;
            @ApiModelProperty(value = "最大架设纵坡")
        private BigDecimal maxErectionLongitudinalSlope;
            @ApiModelProperty(value = "前支腿调节长度")
        private BigDecimal adjustableLengthOfFrontOutrigger;
            @ApiModelProperty(value = "最大架设横坡")
        private BigDecimal maxErectionCrossSlope;
            @ApiModelProperty(value = "整机高度")
        private BigDecimal overallHeight;
            @ApiModelProperty(value = "整机宽度")
        private BigDecimal overallWidth;
            @ApiModelProperty(value = "整机总功率")
        private BigDecimal overallUnitPower;
            @ApiModelProperty(value = "小车纵移速度")
        private BigDecimal smallcarLongitudinalMovingSpeed;
            @ApiModelProperty(value = "过孔速度")
        private BigDecimal throughHoleVelocity;
            @ApiModelProperty(value = "整机横移速度")
        private BigDecimal overallTraverseSpeed;
            @ApiModelProperty(value = "小车横移速度")
        private BigDecimal smallcarTraverseSpeed;
            @ApiModelProperty(value = "整机长度")
        private BigDecimal overallLength;
            @ApiModelProperty(value = "前导梁长度")
        private BigDecimal lengthOfFrontGuideBeam;
            @ApiModelProperty(value = "起升机构减速器型号")
        private String hoistReducerModel;
            @ApiModelProperty(value = "大车行走适应轨道")
        private String bigcarTraveAdaptationTrack;
            @ApiModelProperty(value = "大车行走制动器型号")
        private String bigcarTraveBrakeModel;
            @ApiModelProperty(value = "小车行走机构小车车轮踏面直径")
        private BigDecimal smallcarTraveSmallTreadDiameter;
            @ApiModelProperty(value = "小车行走机构制动器型号")
        private String smallcarTraveBrakeModel;
            @ApiModelProperty(value = "小车横移机构速度")
        private BigDecimal smallcarSideswaySpeed;
            @ApiModelProperty(value = "小车横移机构功率")
        private BigDecimal smallcarSideswayPower;
            @ApiModelProperty(value = "小车横移机构转速")
        private BigDecimal smallcarSideswayRevolveSpeed;
            @ApiModelProperty(value = "小车横移机构工作级别")
        private String smallcarSideswayWorkingLevel;
            @ApiModelProperty(value = "小车横移机构减速器型号")
        private String smallcarSideswayReducerModel;
            @ApiModelProperty(value = "小车横移机构传动比")
        private String smallcarSideswayTransmissionRatio;
            @ApiModelProperty(value = "小车横移机构小车横移轨道")
        private String smallcarSideswaySmallTraverseTrack;
            @ApiModelProperty(value = "小车横移机构制动器型号")
        private String smallcarSideswayBrakeModel;
            @ApiModelProperty(value = "小车横移机构制动力矩")
        private BigDecimal smallcarSideswayBrakTorque;
            @ApiModelProperty(value = "小车横移机构小车横移车轮踏面直径")
        private BigDecimal smallcarSideswayTreadDiameter;
            @ApiModelProperty(value = "小车横移机构电机型号")
        private String smallcarSideswayMotorQuantity;
            @ApiModelProperty(value = "小车横移机构电机数量")
        private Integer smallcarSideswayMotorNumber;
            @ApiModelProperty(value = "悬臂长度")
        private BigDecimal cantileverLength;
            @ApiModelProperty(value = "使用场所")
        private String placeUse;
            @ApiModelProperty(value = "变幅速度")
        private BigDecimal derrickingSpeed;
            @ApiModelProperty(value = "最大幅度起重量")
        private BigDecimal maximumLiftingCapacity;
            @ApiModelProperty(value = "导轨架")
        private String guideRailFrame;
            @ApiModelProperty(value = "层数")
        private Integer numberOfPlies;
            @ApiModelProperty(value = "整机重量")
        private BigDecimal operatingWeight;
            @ApiModelProperty(value = "起升机构制动力矩")
        private BigDecimal hoistBrakingTorque;
            @ApiModelProperty(value = "起升机构钢丝绳型号")
        private String hoistWireRope;
            @ApiModelProperty(value = "吊笼数量")
        private String hangingCagesNumber;

            @ApiModelProperty(value = "安全保护装置")
        private String safetyProtectionDevice;
            @ApiModelProperty(value = "主要零部件")
        private String mainPart;

    
}
