package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 单位资质证书表
 *
 * @author system_generator
 * @date 2025-07-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_base_enterprise_cert")
public class BaseEnterpriseCert extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位编码-不带证件类型的，来源tz_base_enterprise_info的use_unit_code
     */
    @TableField("unit_code")
    private String unitCode;

    /**
     * 证书类型
     */
    @TableField("cert_type")
    private String certType;

    /**
     * 证书类型code
     */
    @TableField("cert_type_code")
    private String certTypeCode;

    /**
     * 证书编号（核准证编号）
     */
    @TableField("cert_no")
    private String certNo;

    /**
     * 有效期至
     */
    @TableField("expiry_date")
    private Date expiryDate;

    /**
     * 发证日期
     */
    @TableField("issue_date")
    private Date issueDate;

    /**
     * 发证机关名称
     */
    @TableField("approved_organ")
    private String approvedOrgan;

    /**
     * 发证机关code
     */
    @TableField("approved_organ_code")
    private String approvedOrganCode;

    /**
     * 企业资质证书照片
     */
    @TableField("qualification_certificate_attachment")
    private String qualificationCertificateAttachment;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 机构类别
     */
    @TableField("agency_type")
    private String agencyType;


    /**
     * 分类-哪个身份创建的证书
     */
    @TableField("unit_type")
    private String unitType;

    /**
     * 证的状态：报检预留字段，如启用、停用、超期等
     */
    @TableField("cert_state")
    private Integer certState;

    /**
     * 机构分类
     */
    @TableField(value = "agency_classify")
    private String agencyClassify;
}
