package com.yeejoin.amos.boot.module.jczs.api.enums;

/**
 * 
 * <pre>
 * 电梯安全回路状态枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftCircuitStatusEnum.java, v 0.1 2021年9月29日 上午9:23:00 gwb Exp $
 */
public enum LiftBitStatusEnum{

	NO(1,"否"),
	YES (2,"是");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftBitStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftBitStatusEnum getEnum(Integer code)
	{
		for (LiftBitStatusEnum liftBitStatusEnum : LiftBitStatusEnum.values())
		{
			if (liftBitStatusEnum.getCode().equals(code))
			{
				return liftBitStatusEnum;
			}
		}
		return null;
	}
}
