package com.yeejoin.amos.boot.module.jyjc.api.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipDto;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.api.vo.JyjcInspectionApplicationVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-14
 */
public interface JyjcInspectionApplicationMapper extends BaseMapper<JyjcInspectionApplication> {

    Page<JyjcInspectionApplicationEquipModel> listByCategory(Page<JyjcInspectionApplicationEquipModel> page, @Param("equipClassify") String equipClassify);

    JyjcInspectionApplicationModel selectDataBySeq(Long sequenceNbr);

    void updatePromoter(@org.apache.ibatis.annotations.Param("id") Long id);

    Page<JyjcInspectionApplicationModel> selectForPage(@Param("page") Page<JyjcInspectionApplication> page,
                                                       @Param("jyjcInspectionApplicationModel") JyjcInspectionApplicationModel jyjcInspectionApplicationModel,
                                                       @Param("identity") String identity,
                                                       @Param("currentApplicationUnitCode") String currentApplicationUnitCode,
                                                       @Param("currentInspectionUnitCode") String currentInspectionUnitCode,
                                                       @Param("currentUserId") String currentUserId,
                                                       @Param("sort") SortVo sortMap,
                                                       @Param("orgCode") String orgCode);

 Page<JyjcInspectionApplicationModel> selectForPage2(@Param("page") Page<JyjcInspectionApplication> page,
                                                     @Param("jyjcInspectionApplicationModel") JyjcInspectionApplicationModel jyjcInspectionApplicationModel,
                                                     @Param("client") String client,
                                                     @Param("companyCode") String companyCode,
                                                     @Param("sort") SortVo sortMap,
                                                     @Param("orgCode") String orgCode,@Param("agencyClassify") String agencyClassify);


 /**
     * 查询待受理流流程状态的设备
     *
     * @return Set<String>
     */
    Set<String> queryRecordInFlowing(@Param("applicationUnitCode") String applicationUnitCode);


   /**
    *  查询待受理流流程状态的设备
    * @param equips 需要判断的设备
    * @return 在流程中的设备records
    */
    List<String> queryRecordListInFlowing(@Param("equips") List<JyjcInspectionApplicationEquipDto> equips);

    /**
     * 按照检验类型、机构、时间统计检验数量(流程中及已完成的)
     *
     * @param orgCode 区域对应公司orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计信息
     */
    List<CountDto> queryAllFlowingAndFinishedInspectApp(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 查询待出结果的报检单据数量
     *
     * @param orgCode 区域对应公司orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计信息
     */
    List<CountDto> queryAllPendingResultInspectApp(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 按照8大类，查询指定区域下的报检数量、待检数量
     * @param orgCode 指定区域对应的公司
     * @param dpFilterParamDto 时间过滤条件
     * @return List<CountDto>
     */
    List<CountDto> queryAppByEquListForDP(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 按照8大类，统计
     * @param orgCode 指定区域对应的公司
     * @param dpFilterParamDto 时间过滤条件
     * @return CountDto
     */
    CountDto queryAppByEquListForReporting(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    Long queryAllFlowingAndFinishedCount(@Param("orgCode") String orgCode, @Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    Long queryAllPendingAndFinishedCount(@Param("orgCode") String orgCode, @Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    Long queryAllFinishedCount(@Param("orgCode") String orgCode, @Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    Long countBizFinishedNumForDP(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto, @Param("businessType") String businessType);

    Long countAllInFlowingForDPNoFinishedBizData(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto, @Param("businessType") String businessType);

    Page<Map<String, Object>> getInspectDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("businessType") String businessType);

    Page<Map<String, Object>> getInspectBusinessList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("businessType") String businessType);

    Long queryQualifiedCount(@Param("orgCode") String orgCode, @Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    Page<Map<String, Object>> queryAllList( @Param("page") Page page,@Param("orgCode") String orgCode, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long queryAllFlowingAndFinishedCountForDetail(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long queryAllPendingAndFinishedCountForDetail(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long queryAllFinishedCountForDetail(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<JyjcInspectionApplicationVo> queryExportInIds(@Param("ids") List<String> ids);

    /**
     * 查询指定装置下的管道，样式为汇总表样式
     * @param projectContraptionSeq 装置id
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> selectPieLineListByProjectId(@Param("projectContraptionSeq") String projectContraptionSeq);

    /**
     * 查询指定管道的信息，样式为汇总表样式
     * @param records 管道ids
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> selectPieLineListOfInspect(@Param("records") List<String> records);

    /**
     * 查询指定管道的信息，样式为汇总表样式-无检验信息
     * @param records 管道ids
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> selectPieLineListOfNoInspectInfo(@Param("records") List<String> records);

    Page<JSONObject> selectEquipList(Page<JSONObject> page,@Param("queryParams") Map<String, Object> map);
}


