package com.yeejoin.amos.patrol.business.util;

import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;

public class ResponseHelperUtil {

    public ResponseHelperUtil() {
    }

    public static <T> ResponseModel<T> buildErrorResponse(T t) {
        ResponseModel<T> response = new ResponseModel();
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        response.setResult(t);
        response.setDevMessage("ERROR");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.setTraceId(RequestContext.getTraceId());
        response.setPath(request.getServletPath());
        return response;
    }
}
