package com.yeejoin.amos.boot.module.ymt.flc.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 充装前检查结果DTO
 */
@Data
public class TzCylinderBeforeCheckDto {

    @ApiModelProperty(value = "是否在检验有效期以内")
    /**
     * 是否在检验有效期以内
     */
    private String isValid;
    @ApiModelProperty(value = "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致")
    /**
     * 警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致
     */
    private Integer same;
    @ApiModelProperty(value = "气瓶外表面的颜色标志是否符合规定")
    /**
     * 气瓶外表面的颜色标志是否符合规定
     */
    private Integer isRegulations;
    @ApiModelProperty(value = "气瓶瓶阀的出气口螺纹型式是否符合GB/T15383")
    /**
     * 气瓶瓶阀的出气口螺纹型式是否符合GB/T15383
     */
    private Integer isComplianceWithgbt;
    @ApiModelProperty(value = "气瓶内有无剩余压力")
    /**
     * 气瓶内有无剩余压力
     */
    private Integer haveStillPressure;
    @ApiModelProperty(value = "气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
    /**
     * 气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷
     */
    private Integer isComplete;
    @ApiModelProperty(value = "气瓶的安全附件齐全并符合安全要求")
    /**
     * 气瓶的安全附件齐全并符合安全要求
     */
    private Integer haveSecurityDocuments;
    @ApiModelProperty(value = "新投入使用气瓶或经检验后首次投入使用气瓶，充装前应按照规定先置换瓶内空气，并经分析合格后方可充气")
    /**
     * 新投入使用气瓶或经检验后首次投入使用气瓶，充装前应按照规定先置换瓶内空气，并经分析合格后方可充气
     */
    private String fillBeforeItem;


}
