package com.yeejoin.amos.boot.module.ymt.biz.config;

import com.yeejoin.amos.boot.module.ymt.api.dto.KV;
import com.yeejoin.amos.boot.module.ymt.api.mapper.CategoryOtherInfoMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 初始化监管码和96333码
 *
 * @author LiuLin
 * @date 2023年12月15日 17:47
 */
@Component
public class SupervisionCacheInitializer implements ApplicationRunner {

    private static final Logger log = LoggerFactory.getLogger(SupervisionCacheInitializer.class);
    private final CategoryOtherInfoMapper categoryOtherInfoMapper;
    private final StringRedisTemplate stringRedisTemplate;

    @Autowired
    public SupervisionCacheInitializer(CategoryOtherInfoMapper categoryOtherInfoMapper, StringRedisTemplate stringRedisTemplate) {
        this.categoryOtherInfoMapper = categoryOtherInfoMapper;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void run(ApplicationArguments args) {
        preloadCache(categoryOtherInfoMapper.selectElevatorCodeMaxValue());
        preloadCache(categoryOtherInfoMapper.selectSupervisorCodeMaxValue());
        log.info(">>>>>>>>>>>>>>>>服务启动执行Redis缓存预加载96333和监管数据完成！>>>>>>>>>>>>>>>>");
    }

    /**
     * 预加载缓存
     *
     * @param codeList 待加载的代码列表
     */
    private void preloadCache(List<KV> codeList) {
        codeList.forEach(vo -> stringRedisTemplate.opsForValue().set(vo.getName(), (String) vo.getValue()));
    }
}
