package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;


@EqualsAndHashCode(callSuper = true)
@Data
public class TmCylinderFillingCheckModel extends AbstractBaseModel{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String sequenceCode;	//气瓶唯一标识码*
	private String fillingCheckId;	//充装后复查ID
	private int withinScope;	//充装量在规定范围内*
	private int sealedState;	//瓶阀及其与瓶口连接的密封良好*
	private int defective;	//瓶体未出现鼓包变形或泄露等严重缺陷*
	private int abnormalTemperature;	//瓶体温度没有异常升高的迹象*
	private int warningSign;	//气瓶粘贴警示标签和充装标签*
	private String compliance;	//液化气瓶充装量符合有关规定，充装后逐瓶称重
	private String inspector;	//检查人员姓名*
	private String inspectionDate;	//检查时间*
	private String checkResults;
	private String nonconformances;

	/**
	 * 对接文档已发布字段，需要将此字段赋值给系统数据库中的字段：abnormalTemperature
	 */
	private int abnormaLTemperature;

	public int getAbnormaLTemperature() {
		return abnormalTemperature;
	}

	public void setAbnormaLTemperature(int abnormaLTemperature) {
		this.abnormalTemperature = abnormaLTemperature;
	}


	public int getAbnormalTemperature() {
		return abnormalTemperature;
	}

	public void setAbnormalTemperature(int abnormalTemperature) {
		this.abnormalTemperature = abnormalTemperature;
	}
}
