package com.yeejoin.amos.boot.module.elevator.api.service;


import com.yeejoin.amos.boot.module.elevator.api.dto.DispatchTaskDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.MainPersonDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatDispatchFeedbackDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatMessageDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatMyBussinessDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatMyTaskDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatMyTaskListDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.WechatUserFeedbackDto;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import java.util.List;

/**
 * 派遣任务接口类
 *
 * @author kongfm
 * @date 2021-08-03
 */
public interface IDispatchTaskService {


    Boolean createDispatchTask(DispatchTaskDto dispatchTaskDto, AgencyUserModel sendUser);

    DispatchTaskDto getTaskInfo(String orgTypeCode, Long alertId);

    String returnDistanceByTaskId(Long taskId, String longitude, String latitude);

    WechatMyTaskDto getTaskInfoByTaskId(Long taskId);

    Boolean taskArrive(Long taskId);

    Boolean saveFinish(Long taskId);

    List<WechatMyTaskListDto> getTaskListByPhonePager(String phone, String typeCode, Long current);

    WechatMyTaskDto saveWechatFeedBack(WechatDispatchFeedbackDto wechatDispatchFeedbackDto);

    /**
     * 返回封装的WechatMessageDto
     * @return
     */
    WechatMessageDto getWechatMessageDtoByDispatchTaskDto(DispatchTaskDto dispatchTaskDto);

    List<MainPersonDto> todayTaskPerson();

    WechatMyBussinessDto saveUserFeed(WechatUserFeedbackDto wechatUserFeedbackDto);


}
