package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum StatisticalAnalysisEnum {

    /**
     * 综合统计分析列表查询设备、企业、人员ES索引
     */

    company("企业", "company", "idx_biz_enterprise_info"),
    inspectionCompany("检验检测机构", "inspectionCompany", "idx_biz_enterprise_info"),
    person("人员", "person", "idx_biz_user_info"),
    inspectionPerson("检验检测人员", "inspectionPerson", "idx_biz_user_info"),
    equip("设备", "equip", "idx_biz_equipment_info");

    private String name;

    private String code;

    private String key;

    private static final Map<String, StatisticalAnalysisEnum> CODE_MAP = new HashMap<>();

    static {
        for (StatisticalAnalysisEnum value : values()) {
            CODE_MAP.put(value.code, value);
        }
    }

    public static Map<String, String> getKey = new HashMap<>();


    static {
        for (StatisticalAnalysisEnum e : StatisticalAnalysisEnum.values()) {
            getKey.put(e.code, e.key);
        }
    }

    /**
     * 根据code获取枚举实例（优化版）
     * @param code 枚举编码
     * @return 对应的枚举实例，未找到时返回null
     */
    public static StatisticalAnalysisEnum getEnumByCode(String code) {
        return CODE_MAP.get(code);
    }
}
