package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import lombok.Data;

/**
 * 管道已纳管设备
 */
@Data
public class PipeEquipmentVo {


    @ExcelProperty(value = "工程（装置）编号/项目编号")
    String projectContraptionNo;

    @ExcelProperty(value = "工程（装置）名称/项目名称")
    String projectContraption;

    @ExcelProperty(value = "设备种类")
    String equListName;

    @ExcelProperty(value = "设备类别")
    String equCategoryName;

    @ExcelProperty(value = "设备品种")
    String equDefineName;

    @ExcelProperty(value = "使用单位名称")
    String useUnitName;

    @ExcelProperty(value = "使用登记证")
    String useRegistrationCode;

    @ExcelProperty(value = "属地监管部门")
    String orgName;

    @ExcelProperty(value = "监管码")
    String supervisoryCode;

    @ExcelProperty(value = "投入年月")
    @JsonFormat(pattern = "yyyy-MM")
    String useDate;

    @ExcelProperty(value = " 设备使用地点省")
    @DictCode2DictName(typeHandler = "regionCodeTypeHandler")
    String province;

    @ExcelProperty(value = " 设备使用地点市")
    @DictCode2DictName(typeHandler = "regionCodeTypeHandler")
    String city;

    @ExcelProperty(value = "设备使用地点区(县)")
    @DictCode2DictName(typeHandler = "regionCodeTypeHandler")
    String county;

    @ExcelProperty(value = "设备使用地点街道(镇)")
    @DictCode2DictName(typeHandler = "regionCodeTypeHandler")
    String street;

    @ExcelProperty(value = "设备详细使用地点")
    String address;

    @ExcelProperty(value = "管道编号")
    String pipelineNumber;

    @ExcelProperty(value = "管道名称（登记单元）")
    String pipeName;

    @ExcelProperty(value = "设计单位")
    String designUnitName;

    @ExcelProperty(value = "设计-压力(MPa)")
    String pressure;

    @ExcelProperty(value = "设计-介质")
    String medium;

    @ExcelProperty(value = "设计-温度(℃)")
    String temperature;

    @ExcelProperty(value = "工作条件-温度(℃)")
    String workTemperature;

    @ExcelProperty(value = "检验/检测机构名称")
    String inspectOrgName;

    @ExcelProperty(value = "安装单位")
    String uscUnitName;

    @ExcelProperty(value = "安装年月")
    @JsonFormat(pattern = "yyyy-MM")
    String uscDate;

    @ExcelProperty(value = "工作条件-压力(MPa)")
    String workPressure;

    @ExcelProperty(value = "检验结论")
    @DictCode2DictName(type = "JYJL", typeHandler = "cbDataDictTypeHandler")
    String inspectConclusion;

    @ExcelProperty(value = "下次检验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    String nextInspectDate;

    @ExcelProperty(value = "管道规格-管道长度(m)")
    String pipeLength;

    @ExcelProperty(value = "管道级别")
    @DictCode2DictName(type = "GYGDHIS", typeHandler = "cbDataDictTypeHandler")
    String deviceLevel;

    @ExcelProperty(value = "工作条件-介质")
    String workMedium;

    @ExcelProperty(value = "管道规格-公称直径(mm)")
    String nominalDiameter;

    @ExcelProperty(value = "管道规格-公称壁厚(mm)")
    String wallThickness;

    @ExcelProperty(value = "备注")
    String remarks;

}
