package com.yeejoin.amos.patrol.business.entity.mybatis.extend;

import lombok.Data;

import java.util.Date;

/**
 * 隐患表
 */
@Data
public class LatentDangerBo {

    /**
     * 主键自增
     */
    private Long id;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 业务唯一标识
     */
    private String businessKey;

    /**
     * 公司组织机构
     */
    private String orgCode;

    /**
     * 隐患名称
     */
    private String dangerName;

    private String instanceId;

    private Long currentFlowRecordId;

    /**
     * 隐患等级（1：一般隐患；2：重大隐患；0：安全问题）
     */
    private String dangerLevel;

    private String dangerLevelName;

    /**
     * 隐患地点
     */
    private String dangerPosition;

    /**
     * 隐患类型（1：普通隐患；2：巡检隐患）
     */
    private String dangerType;

    private String dangerTypeName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 整改类型（1：常规整改；2：安措计划；3：延期整改）
     */
    private String reformType;

    private String reformTypeName;

    /**
     * 限制时间
     */
    private Date reformLimitDate;

    private Integer overtimeState;

    private String reformJson;

    /**
     * 隐患状态（1：待评审；2：待治理；3：安措计划中；4：逾期未治理；5：待验证；6：治理完毕；7：已撤销）
     */
    private String dangerState;

    private String dangerStateName;

    /**
     * 发现人
     */
    private String discovererUserId;

    private String discovererDepartmentId;

    private String photoUrls;

    /**
     * 是否删除（0：否；1：是）
     */
    private Integer deleted;

    /**
     * 记录创建时间
     */
    private Date createDate;

    /**
     * 记录修改时间
     */
    private Date updateDate;

    /**
     * 延期治理时间
     */
    private Date delayLimitDate;

    /**
     * 问题描述
     */
    private String problemDescription;

    /**
     * 原因分析
     */
    private String reasonAnalysis;

    /**
     * 举一反三
     */
    private String inferOtherThings;

    /**
     * 检查记录创建的隐患检查项对应id
     */
    private Long bizId;

    /**
     * 建筑id
     */
    private Long structureId;

    /**
     * 建筑名称
     */
    private String structureName;

    private String instanceKey;
}
