package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ys.biz.service.CommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.velocity.runtime.directive.Evaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author system_generator
 * @date 2024-09-24
 */
@RestController
@Api(tags = "公共接口")
@RequestMapping(value = "/common")
public class CommonController extends BaseController {

    @Autowired
    private CommonService commonService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "应急保障四项统计", notes = "应急保障四项统计")
    @RequestMapping(value = "/emergencySupportStatistics/{businessType}/{componentType}", method = RequestMethod.GET)
    public ResponseModel<Object> queryForPage(
            @ApiParam(value = "业务类型（教育培训：education、体系建设：construct、应急演练：rehearsal、应急预案：prePlan）", required = true)
            @PathVariable(value = "businessType") String businessType,
            @ApiParam(value = "组件类型（饼图：pieChart、富文本：richText）", required = true)
            @PathVariable(value = "componentType") String componentType) {
        return ResponseHelper.buildResponse(commonService.emergencySupportStatistics(businessType, componentType));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "安全追溯-综合分析统计", notes = "安全追溯-综合分析统计")
    @RequestMapping(value = "/safetyTraceabilitySynthesis/{statisticalType}", method = RequestMethod.GET)
    public ResponseModel<Object> safetyTraceability(
            @PathVariable(value = "statisticalType") String statisticalType) {
        return ResponseHelper.buildResponse(commonService.safetyTraceabilitySynthesis(statisticalType));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "运营监管分析中间地图", notes = "运营监管分析中间地图")
    @RequestMapping(value = "/analysis/cityMapData", method = RequestMethod.GET)
    public ResponseModel<Object> analysisCityMapData(@RequestParam(value = "firstMenuKey") String firstMenuKey,
                                                     @RequestParam(value = "secondMenuKey") String secondMenuKey) {
        return ResponseHelper.buildResponse(commonService.analysisCityMapData(firstMenuKey, secondMenuKey));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "运营监管分析右侧安全监管-两个清单", notes = "运营监管分析右侧安全监管-两个清单")
    @RequestMapping(value = "/analysis/twoLists", method = RequestMethod.GET)
    public ResponseModel<Object> analysisTwoLists(@RequestParam(value = "type") String type) {
        return ResponseHelper.buildResponse(commonService.analysisTwoLists(type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "运营监管分析右侧安全监管-专项整治", notes = "运营监管分析右侧安全监管-专项整治")
    @RequestMapping(value = "/analysis/specialRectification", method = RequestMethod.GET)
    public ResponseModel<Object> analysisSpecialRectification(@RequestParam(value = "type") String type) {
        return ResponseHelper.buildResponse(commonService.analysisSpecialRectification(type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "运营监管分析右侧安全监察-环状单值图", notes = "运营监管分析右侧安全监察-环状单值图")
    @RequestMapping(value = "/analysis/safetySupervision", method = RequestMethod.GET)
    public ResponseModel<Object> analysisSafetySupervision(@RequestParam(value = "type") String type) {
        return ResponseHelper.buildResponse(commonService.analysisSafetySupervision(type));
    }
}
