package com.yeejoin.precontrol.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.service.IVideoBlockService;
import com.yeejoin.precontrol.common.vo.VideoBlockVo;
import com.yeejoin.precontrol.common.ws.WebSocketVideoBlock;
import com.yeejoin.precontrol.controller.publics.BaseController;

/**
 * @Author: songLei
 * @Description:
 * @Date: 2021/10/15 10:08
 * @Version: 1.0
 */
@RestController
@RequestMapping("/videoBlock")
public class VideoBlockController extends BaseController {
	@Autowired
	private IVideoBlockService videoBlockService;

	/**
	 * @Description 记录用户浏览
	 * @Return Boolean
	 * @Date 2021/10/15 15:05
	 */
	@GetMapping("/browseVideo")
	public Boolean browseVideo() {
		AgencyUserModel model = getUserInfo();
		return videoBlockService.browseVideo(model);
	}

	/**
	 * @Description 离开浏览
	 * @Return Boolean
	 * @Date 2021/10/15 15:28
	 */
	@GetMapping("/leaveBrowse")
	public Boolean leaveBrowse() {
		AgencyUserModel model = getUserInfo();
		return videoBlockService.leaveBrowse(model);
	}

	/**
	 * @Description 列表
	 * @Return Boolean
	 * @Date 2021/10/15 15:28
	 */
	@GetMapping("/getPage")
	public IPage<VideoBlockVo> getPage(CommonPageableDto pageable, VideoBlockVo vo) {
		Person person =getPerson();
		Page page = new Page();
		if (pageable.getPageNumber() != null) {
			page.setCurrent(pageable.getPageNumber());
		}
		if (pageable.getPageSize() != null) {
			page.setSize(pageable.getPageSize());
		}
		vo.setOrgCode(person!=null?person.getOrgCode():null);
		return videoBlockService.getPage(page, vo);
	}

	@PostMapping("/stop")
	public boolean stop(@RequestBody VideoBlockVo vo) {
		WebSocketVideoBlock.stop(vo.getPersonId());
		return true;
	}
}
