package com.yeejoin.amos.patrol.quartz;

import java.util.Date;

import com.yeejoin.amos.patrol.dao.entity.Msg;
import com.yeejoin.amos.patrol.dao.entity.PlanTask;
import com.yeejoin.amos.patrol.dao.entity.Task;

public interface IJobService {
	
	/**
	 * 初始化定时任务
	 */
	public void initScheduler();
	
	/**
	 * 定时任务添加
	 * @param name
	 * @param jobType
	 * @param id
	 * @param time
	 */
	public void addJob(String name,String jobType,long id,Date time);
	
	/**
	 * 计划任务定时任务添加
	 * @param planTask
	 */
	public void planTaskAddJob(PlanTask planTask);
	
	/**
	 * 计划任务定时任务执行
	 * @param planTaskId
	 * @param jobType
	 * @param jobName
	 */
	public void planTaskJobPerform(long planTaskId,String jobType,String jobName);
	/**
	 * 任务定时任务添加
	 * @param Task
	 */
	public void taskAddJob(Task task);
	
	/**
	 * 任务定时任务执行
	 * @param taskId
	 * @param jobType
	 * @param jobName
	 */
	public void taskJobPerform(long taskId,String jobType,String jobName);
	
	/**
	 * 添加消息定时任务
	 * @param msg
	 */
	public void msgAddJob(Msg msg);
	/**
	 * 消息发送定时任务
	 * @param taskId
	 * @param jobType
	 * @param jobName
	 */
	public void msgJobPerform(long msgId,String jobType,String jobName);
	
	
	
}
