package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.ToDoTasksDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ToDoTasksPageDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.ToDoTasks;
import com.yeejoin.amos.boot.module.hygf.api.mapper.ToDoTasksMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ToDoTasksServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人员任务
 *
 * @author system_generator
 * @date 2023-09-08
 */
@RestController
@Api(tags = "人员任务Api")
@RequestMapping(value = "/to-do-tasks")
public class ToDoTasksController extends BaseController {

    @Autowired
    ToDoTasksServiceImpl toDoTasksServiceImpl;
    @Autowired
    ToDoTasksMapper toDoTasksMapper;
    /**
     * 新增人员任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增人员任务", notes = "新增人员任务")
	public ResponseModel<ToDoTasksDto> save(@RequestBody ToDoTasksDto model) {
	    model = toDoTasksServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新人员任务", notes = "根据sequenceNbr更新人员任务")
	public ResponseModel<ToDoTasksDto> updateBySequenceNbrToDoTasks(@RequestBody ToDoTasksDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(toDoTasksServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除人员任务", notes = "根据sequenceNbr删除人员任务")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(toDoTasksServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员任务",  notes = "根据sequenceNbr查询单个人员任务")
	public ResponseModel<ToDoTasksDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(toDoTasksServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "人员任务分页查询",  notes = "人员任务分页查询")
	public ResponseModel<IPage<ToDoTasks>> queryForPage(ToDoTasksPageDto toDoTasksPageDto) {

        toDoTasksPageDto.setAmosUserId(getUserInfo().getUserId());
	    return ResponseHelper.buildResponse(toDoTasksServiceImpl.queryToDoTasksPageDto(toDoTasksPageDto));
	}





	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "人员任务列表全部数据查询",   notes = "人员任务列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ToDoTasksDto>> selectForList() {
	    return ResponseHelper.buildResponse(toDoTasksServiceImpl.queryForToDoTasksList());
	}


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/count")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员任务",  notes = "根据sequenceNbr查询单个人员任务")
    public ResponseModel<Map<String,Object>> count() {
        String userid=getUserInfo().getUserId();
        LambdaQueryWrapper<ToDoTasks> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ToDoTasks::getAmosUserId, userid);
        wrapper.eq(ToDoTasks::getState, "待办");
        Integer DB= toDoTasksMapper.selectCount(wrapper);
        LambdaQueryWrapper<ToDoTasks> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(ToDoTasks::getAmosUserId, userid);
        wrapper1.eq(ToDoTasks::getState, "已办");
        Integer YB= toDoTasksMapper.selectCount(wrapper1);
        Map<String,Object> map =new HashMap<>();
        map.put("DB",DB==null?0:DB);
        map.put("YB",YB==null?0:YB);
        return ResponseHelper.buildResponse(map);
    }


}
