package com.yeejoin.precontrol.common.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: 人员dto
 * @Author: sqy
 * @Date: 2020/11/11
 */
@Data
public class PersonDto extends BaseDto implements Serializable {
	private static final long serialVersionUID = -9128405513441879127L;

	@ApiModelProperty(value = "姓名")
	private String name;

	@ApiModelProperty(value = "性别( 0-男 1-女 )")
	private Long sex;
	@TableField(exist = false)
	private String sexLabel;

	@ApiModelProperty(value = "生日")
	private Date birthday;
	@ApiModelProperty(value = "年龄")
	private Long age;
	@ApiModelProperty(value = "名族")
	private String folkKey;
	@ApiModelProperty(value = "身高")
	private Long height;
	@ApiModelProperty(value = "体重")
	private Long weight;
	@ApiModelProperty(value = "电话")
	private String phone;
	@ApiModelProperty(value = "应急电话")
	private String emergencyPhone;
	@ApiModelProperty(value = "政治面貌")
	private String politicCountenance;
	@ApiModelProperty(value = "证件编号")
	@TableField("ID_number")
	private String idNumber;
	@ApiModelProperty(value = "证件类型")

	@TableField("ID_type")
	private Long idType;
	@TableField(exist = false)
	private String idTypeLabel;

	@ApiModelProperty(value = "籍贯")
	private String nativePlace;
	@TableField(exist = false)
	private String nativePlaceLabel;

	@ApiModelProperty(value = "用工来源所在地")
	private String employPlace;
	@TableField(exist = false)
	private String employPlaceLabel;

	@ApiModelProperty(value = "地址")
	private String address;
	@ApiModelProperty(value = "现住址")
	private String presentAddress;

	@ApiModelProperty(value = "参加工作时间")
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date workTime;
	@ApiModelProperty(value = "头像照片")
	@ImagePrefix
	private String headPhoto;
	@ApiModelProperty(value = "证件照片正面")
	@ImagePrefix
	private String frontCertificatePhoto;
	@ApiModelProperty(value = "证件照片反面")
	@ImagePrefix
	private String backCertificatePhoto;
	@ApiModelProperty(value = "考核成绩")
	private Long examineScore;
	@ApiModelProperty(value = "是否合格")
	private Boolean qualified;
	@ApiModelProperty(value = "综合评分")
	private Float compositeScore;
	@ApiModelProperty(value = "是否可用")
	private Long isEnabled;
	@ApiModelProperty(value = "平台账号userId")
	private String userId;
	@ApiModelProperty(value = "平台账号名称")
	private String accountName;
	@ApiModelProperty(value = "二维码颜色0红 1黄 2绿")
	private Long color;
	@ApiModelProperty(value = "积分")
	private Double integral;
	@ImagePrefix
	private Company company;

	private Project project;

	private PersonAscription personAscription;// 人员归属信息
	@ImagePrefix
	private PersonSkillEducation personSkillEducation;// 人员技能和学历
	@ImagePrefix
	private List<PersonQualifications> personQualifications;// 人员资质信息
	@ImagePrefix
	private PersonContract personContract;// 人员合同信息
	@ImagePrefix
	private PersonExamination personExamination;// 人员体检信息
	@ImagePrefix
	private PersonInsurance personInsurance;// 人员保险信息
	private List<PersonClock> personClock;// 人员履历信息
	private List<PersonWorkingHours> personWorkingHours;// 工时信息

	private List<PersonExam> personExams;// 人员考试信息

	@ApiModelProperty(value = "用户角色名称")
	private String roleName;

	private Long id;
	/**
	 * 创建时间
	 */
	private Date createDate;

	private boolean isJxdj;
	@ApiModelProperty(value = "工号")
	private String jobNumber;

	@ApiModelProperty(value = "激活状态，用于出入场")
	private Long activeStatus;
	@ApiModelProperty(value = "激活状态，用于出入场描述")
	private String activeStatusLabel;
	@ApiModelProperty(value = "合格阶段")
	private Integer qualifiedStage;
	@ApiModelProperty(value = "账户信息")
	private PersonAccount personAccount;
}
