package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 项目信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project")
@ApiModel(value = "Project对象", description = "项目信息")
public class Project extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "项目名称")
    private String name;
    @ApiModelProperty(value = "手机号码")
    private Long phone;
    @ApiModelProperty(value = "项目经理")
    private String manager;
    @ApiModelProperty(value = "邮箱")
    private String email;
    @ApiModelProperty(value = "建设单位")
    private String company;
    @ApiModelProperty(value = "地区")
    private String region;
    @ApiModelProperty(value = "经度")
    private Double longitude;
    @ApiModelProperty(value = "纬度")
    private Double latitude;
    @ApiModelProperty(value = "打卡半径")
    private Double clockScope;
    @ApiModelProperty(value = "项目地址")
    private String address;
    @ApiModelProperty(value = "简介")
    private String introduction;
    @ApiModelProperty(value = "状态")
    private String status;
    @ApiModelProperty(value = "项目开始时间")
    private Date startTime;
    @ApiModelProperty(value = "项目编号")
    private String projectNum;
    @ApiModelProperty(value = "地图点类型")
    private String pointType;
    @ApiModelProperty(value = "地图数据")
    private String lineJson;
    @ApiModelProperty(value = "未交底次数")
    private Long jobNum;
    @ApiModelProperty(value = "机构ID")
    private String orgCode;
    @ApiModelProperty(value = "项目关联区域")
    private String projectRegion;
    @ApiModelProperty(value = "项目类型")
    private Integer type;
    @ApiModelProperty(value = "是否有专户")
    private boolean hasAccount;
}
