package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 微型消防站
 *
 * @author system_generator
 * @date 2021-06-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FireStationDto", description = "微型消防站")
public class FireStationDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "微型消防站名称", index = 0)
    @ApiModelProperty(value = "微型消防站名称")
    private String name;

    @ExcelIgnore
    @ApiModelProperty(value = "所在建筑物id")
    private String whereBuildingId;

    @ExplicitConstraint(indexNum = 1, sourceClass = CommonExplicitConstraint.class, method = "getBuildingList")
    @ExcelProperty(value = "所在建筑", index = 1)
    @ApiModelProperty(value = "所在建筑物名称")
    private String whereBuilding;

    @ExcelProperty(value = "地址", index = 2)
    @ApiModelProperty(value = "地址")
    private String address;

    @ExcelProperty(value = "联系电话", index = 3)
    @ApiModelProperty(value = "值班室电话")
    private String dutyRoomTelephone;

    @ExcelIgnore
    @ApiModelProperty(value = "负责人名称id")
    private String personChargeId;

    @ExcelProperty(value = "负责人名称", index = 4)
    @ApiModelProperty(value = "负责人名称")
    private String personChargeName;

    @ExcelProperty(value = "负责人电话", index = 5)
    @ApiModelProperty(value = "负责人电话")
    private String personChargeTelephone;

    @ExcelIgnore
    @ApiModelProperty(value = "单位id")
    private Long bizCompanyId;

    @ExplicitConstraint(indexNum = 6, sourceClass = CommonExplicitConstraint.class, method = "getBizCompanyList")
    @ExcelProperty(value = "所属单位", index = 6)
    @ApiModelProperty(value = "所属单位名称")
    private String bizCompany;

    @ExcelIgnore
    @ApiModelProperty(value = "所属单位code")
    private String bizCompanyCode;

    @ExcelProperty(value = "建造日期", index = 7)
    @ApiModelProperty(value = "建造日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date buildTime;

    @ExcelProperty(value = "启用日期", index = 8)
    @ApiModelProperty(value = "启用日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date enableTime;

    @ExcelProperty(value = "装备简要情况", index = 9)
    @ApiModelProperty(value = "装备简要情况")
    private String equipmentBrief;
    /*bug 2963 微型消防站,导入模板里面不应该有照片字段  2021-09-24 CEHNZHAO*/
    @ExcelIgnore
    @ApiModelProperty(value = "图片信息")
    private String img;

    @ExcelIgnore
    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ExcelIgnore
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ExcelIgnore
    @ApiModelProperty(value = "行政区区划名称")
    private String administrativeDivisions;

    @ExcelIgnore
    @ApiModelProperty(value = "行政区区划编号")
    private String administrativeDivisionsCode;

    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "战备装备数量")
    private Integer eqNum;

    @ExcelIgnore
    @ApiModelProperty(value = "战备人数量")
    private Integer userNum;

    @ExcelIgnore
    @ApiModelProperty(value = "战备车辆数量")
    private Integer carNum;

    @ExcelIgnore
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

}