package com.yeejoin.amos.patrol.business.cache;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.patrol.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;

@Component
public class CacheHelper {

    @Autowired
    IInputItemDao iInputItemDao;


    @Autowired
    RedisUtils redisUtils;

    private static final String P_INPUT_ITEM_REDIS_KEY_PREFIX = "P_INPUT_ITEM_CACHE_KEY:";

    @PostConstruct
    public void init() {
        List<InputItem> inputItems = iInputItemDao.findAll();
        redisUtils.del(P_INPUT_ITEM_REDIS_KEY_PREFIX);
        inputItems.forEach(inputItem -> redisUtils.hset(P_INPUT_ITEM_REDIS_KEY_PREFIX, String.valueOf(inputItem.getId()), inputItem, 3600));
    }

    public InputItem getInputItemCacheData(String inputItemId) {
        if(redisUtils.hHasKey(P_INPUT_ITEM_REDIS_KEY_PREFIX, inputItemId)){
            return (InputItem) redisUtils.hget(P_INPUT_ITEM_REDIS_KEY_PREFIX, inputItemId);
        } else {
            synchronized (this){
                if(redisUtils.hHasKey(P_INPUT_ITEM_REDIS_KEY_PREFIX, inputItemId)){
                    return (InputItem) redisUtils.hget(P_INPUT_ITEM_REDIS_KEY_PREFIX, inputItemId);
                } else{
                    List<InputItem> inputItems = iInputItemDao.findAll();
                    inputItems.forEach(inputItem -> redisUtils.hset(P_INPUT_ITEM_REDIS_KEY_PREFIX, String.valueOf(inputItem.getId()), inputItem, 3600));
                    return (InputItem) redisUtils.hget(P_INPUT_ITEM_REDIS_KEY_PREFIX, inputItemId);
                }
            }
        }
    }
}
