package com.yeejoin.amos.boot.module.elevator.api.enums;

/**
 * 
 * <pre>
 * 电梯运行状态枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftStatusEnum.java, v 0.1 2021年9月29日 上午9:32:16 gwb Exp $
 */
public enum LiftStatusEnum{

	STOP (1,"停止"),
	RUN (2,"运行");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftStatusEnum getEnum(Integer code)
	{
		for (LiftStatusEnum liftStatusEnum : LiftStatusEnum.values())
		{
			if (liftStatusEnum.getCode().equals(code))
			{
				return liftStatusEnum;
			}
		}
		return null;
	}
}
