package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.service;

import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.adapter.DocGenerateAdapter;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.DocGeneratorFactory;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.dto.DocGenerationRequest;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.DocGenerator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
@RequiredArgsConstructor
@Slf4j
public class DocGenerateService {

    private final DocGeneratorFactory docGeneratorFactory;

    private final DocGenerateAdapter defaultDocGenerateAdapter;


    public String generateDoc(String appSeq) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        DocGenerationRequest docGenerationRequest = defaultDocGenerateAdapter.prepareRequest(appSeq);
        DocGenerator docGenerator = docGeneratorFactory.getGenerator(docGenerationRequest);
        String path = docGenerator.generate(appSeq);
        stopWatch.stop();
        log.info("生成报检申请表耗时：{}秒", stopWatch.getTotalTimeMillis());
        return path;
    }
}
