package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.strategy.common;

import cn.hutool.core.date.DateUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.typeHandler.EquipCategoryTypeHandler;
import com.yeejoin.amos.boot.module.jyjc.biz.typeHandler.InspectTypeHandler;
import com.yeejoin.amos.boot.module.jyjc.biz.typeHandler.RegionCodeTypeHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@RequiredArgsConstructor
public class InspectAppDocCmService {

    private final JyjcInspectionApplicationServiceImpl jyjcInspectionApplicationService;

    private final EquipCategoryTypeHandler equipCategoryTypeHandler;

    private final InspectTypeHandler inspectTypeHandler;

    private final RegionCodeTypeHandler regionCodeTypeHandler;

    public Map<String, Object> getBaseInFo(String appId) {
        Map<String, Object> baseInfo = new HashMap<>();
        JyjcInspectionApplication inspectionApplication = jyjcInspectionApplicationService.getBaseMapper().selectById(appId);
        baseInfo.put("inspectionType", inspectTypeHandler.handle(inspectionApplication.getInspectionType()));
        baseInfo.put("applicationNo", inspectionApplication.getApplicationNo());
        baseInfo.put("applicationDate", DateUtil.formatDate(inspectionApplication.getApplicationDate()));
        baseInfo.put("applicationUnitName", inspectionApplication.getApplicationUnitName());
        baseInfo.put("applicationContactName", inspectionApplication.getApplicationContactName());
        baseInfo.put("applicationContactPhone", inspectionApplication.getApplicationContactPhone());
        baseInfo.put("address", this.buildAddress(inspectionApplication));
        baseInfo.put("equList", this.equCategoryCode2Name(inspectionApplication.getEquipClassify()));
        baseInfo.put("equCategory", this.equCategoryCode2Name(inspectionApplication.getEquCategory()));
        baseInfo.put("equDefine", this.equCategoryCode2Name(inspectionApplication.getEquDefine()));
        baseInfo.put("remark", inspectionApplication.getProcessDescription());
        baseInfo.put("inspectionUnitName", inspectionApplication.getInspectionUnitName());
        baseInfo.put("acceptDate", DateUtil.formatDate(inspectionApplication.getAcceptDate()));
        return baseInfo;
    }

    private String equCategoryCode2Name(String equipClassify) {
        return equipCategoryTypeHandler.handle(equipClassify);
    }

    private String buildAddress(JyjcInspectionApplication inspectionApplication) {
        return "陕西省" + regionCodeTypeHandler.handle(inspectionApplication.getCity()) + regionCodeTypeHandler.handle(inspectionApplication.getCounty());
    }
}
