package com.yeejoin.amos.boot.biz.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;

public class CommonUtils {

    /**
     * 带索引foreach
     *
     * @param <T>
     * @param startIndex 开始遍历的索引
     * @param elements   集合
     * @param action
     */
    public static <T> void forEach(int startIndex, Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        if (startIndex < 0) {
            startIndex = 0;
        }
        int index = 0;
        for (T element : elements) {
            index++;
            if (index <= startIndex) {
                continue;
            }

            action.accept(index - 1, element);
        }
    }

    public static Object getFiledValueByName(String filedName, Object o) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String firstLetter = filedName.substring(0, 1).toUpperCase();
        String getterName = "get" + firstLetter + filedName.substring(1);
        Method method;
        method = o.getClass().getMethod(getterName, new Class[]{});
        Object value = method.invoke(o, new Object[]{});
        return value;
    }

    /**
     * 深度copyJSONObjet ，用于多个jsonobjectg合并
     * @param source
     * @param target
     * @return
     */
    public static JSONObject deepMergeJSONObject(JSONObject source, JSONObject target) {
        if (target == null) return source;
        for (String key : source.keySet()) {
            Object value = source.get(key);
            if (!target.containsKey(key)) {
                target.put(key, value);  // 直接添加新键
            } else {
                // 若值为 JSONObject，递归合并
                if (value instanceof JSONObject) {
                    deepMergeJSONObject((JSONObject) value, target.getJSONObject(key));
                }
                // 若值为 JSONArray，需处理数组合并（如叠加元素）
                else if (value instanceof com.alibaba.fastjson.JSONArray) {
                    com.alibaba.fastjson.JSONArray srcArr = (com.alibaba.fastjson.JSONArray) value;
                    com.alibaba.fastjson.JSONArray tgtArr = target.getJSONArray(key);
                    for (Object item : srcArr) {
                        if (item instanceof JSONObject) {
                            // 若数组元素为对象，可递归合并（需匹配逻辑）
                            tgtArr.add(item);  // 简单追加示例
                        } else {
                            tgtArr.add(item);  // 基础类型直接添加
                        }
                    }
                }
                else {
                    target.put(key, value);  // 非对象/数组则覆盖
                }
            }
        }
        return target;
    }
}
