package com.yeejoin.amos.boot.module.tcm.biz.config;

import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
@Slf4j
public class RedissonManager {

    /**
     * 集群环境使用-节点信息
     */
    @Value("${spring.redis.cluster.nodes:default}")
    private String clusterNodes;


    /**
     * 公共-密码
     */
    @Value("${spring.redis.password}")
    private String password;

    /**
     * 单机环境使用
     */
    @Value("${spring.redis.host:default}")
    private String host;


    /**
     * 单机环境使用
     */
    @Value("${spring.redis.port:default}")
    private String port;

    /**
     * 单机环境使用
     */
    @Value("${spring.redis.database:0}")
    private int database;

    @Bean
    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "cluster")
    public RedissonClient redissonClient() {
        // 集群环境使用
        Config config = new Config();
        config.useClusterServers()
                .addNodeAddress(clusterNodes.split(","))
                .setPassword(password);
        return Redisson.create(config);
    }

    @Bean
    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "singleton", matchIfMissing = true)
    public RedissonClient redissonSingletonClient() {
        // 单机环境使用
        Config config = new Config();
        config.useSingleServer().setAddress(host + ":" + port).setPassword(password).setDatabase(database);
        return Redisson.create(config);
    }
}
