package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-压力容器
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_vessel")
public class TechParamsVesselChangeFieldDto extends BaseTechParamsFieldDto {

    @FieldDisplayDefine(value = "额定质量")
    private String ratedQuality;

    @FieldDisplayDefine(value = "使用环境温度")
    private String ambientTemperature;

    @FieldDisplayDefine(value = "型号")
    private String modelNumber;

    @FieldDisplayDefine(value = "数量")
    private Integer num;

    @FieldDisplayDefine(value = "单瓶容积")
    private String singleBottleVolume;

    @FieldDisplayDefine(value = "总容积")
    private String totalVolume;

    @FieldDisplayDefine(value = "充装介质", dictCode = "FILLING_MEDIUM", dictType = FieldDisplayDefine.DictType.platform)
    private String chargingMedium;

    @FieldDisplayDefine(value = "规格")
    private String specification;

    @FieldDisplayDefine(value = "外径")
    private String outsideDiameter;

    @FieldDisplayDefine(value = "壁厚")
    private String wallThickness;

    @FieldDisplayDefine(value = "长度")
    private String length;

    @FieldDisplayDefine(value = "公称工作压力")
    private String nominalWorkingPressure;

    @FieldDisplayDefine(value = "材料（瓶体）")
    private String bottleBody;

    @FieldDisplayDefine(value = "材料（端塞）")
    private String endPlug;

    @FieldDisplayDefine(value = "材料（管路）")
    private String piping;

    @FieldDisplayDefine(value = "无损检测方法（气瓶）")
    private String qpLossless;

    @FieldDisplayDefine(value = "无损检测方法（管路）")
    private String glLossless;

    @FieldDisplayDefine(value = "无损检测比例（气瓶）")
    private String qpRatio;

    @FieldDisplayDefine(value = "无损检测比例（管路）")
    private String glRatio;

    @FieldDisplayDefine(value = "耐压试验压力（气瓶）")
    private String qpPressure;

    @FieldDisplayDefine(value = "耐压试验压力（管路）")
    private String glPressure;

    @FieldDisplayDefine(value = "气密性试验压力（气瓶）")
    private String qpAirTightness;

    @FieldDisplayDefine(value = "气密性试验压力（管路）")
    private String glAirTightness;

    @FieldDisplayDefine(value = "气体置换后压力")
    private String displacementPressure;

    @FieldDisplayDefine(value = "瓶体内含氧量")
    private String oxygen;

    @FieldDisplayDefine(value = "瓶体内含氧量")
    private String heatTreatmentMethod;

    @FieldDisplayDefine(value = "热处理温度")
    private String qpHeatTreatmentTemperature;

    @FieldDisplayDefine(value = "气瓶安装位置")
    private String installationPosition;

    @FieldDisplayDefine(value = "容器容积")
    private String containerVolume;

    @FieldDisplayDefine(value = "容器内径")
    private String pressureVesselDiameter;

    @FieldDisplayDefine(value = "容器高(长)")
    private String height;

    @FieldDisplayDefine(value = "材料（筒体(球壳)）")
    private String materialCylinderShell;

    @FieldDisplayDefine(value = "材料（封头）")
    private String pressureMaterialHead;

    @FieldDisplayDefine(value = "材料（衬里）")
    private String pressureMaterialLining;

    @FieldDisplayDefine(value = "材料（夹套）")
    private String materialJacket;

    @FieldDisplayDefine(value = "厚度（筒体(球壳)）")
    private String thickness;

    @FieldDisplayDefine(value = "厚度（封头）")
    private String fixedHead;

    @FieldDisplayDefine(value = "厚度（衬里）")
    private String fixedLining;

    @FieldDisplayDefine(value = "厚度（夹套）")
    private String fixedJacket;

    @FieldDisplayDefine(value = "容器自重")
    private String selfWeight;

    @FieldDisplayDefine(value = "盛装介质重量")
    private String mediumWeight;

    @FieldDisplayDefine(value = "设计压力（壳程）")
    private String pressureHousingPath;

    @FieldDisplayDefine(value = "设计压力（管程）")
    private String pressurePipe;

    @FieldDisplayDefine(value = "设计压力（夹套）")
    private String pressureJacket;

    @FieldDisplayDefine(value = "设计温度（壳程）")
    private String temperatureShell;

    @FieldDisplayDefine(value = "设计温度（管程）")
    private String temperaturePipe;

    @FieldDisplayDefine(value = "设计温度（夹套）")
    private String temperatureJacket;

    @FieldDisplayDefine(value = "最高允许工作压力（壳程）")
    private String maxPressureShell;

    @FieldDisplayDefine(value = "最高允许工作压力（管程）")
    private String maxPressurePipe;

    @FieldDisplayDefine(value = "最高允许工作压力（夹套）")
    private String maxPressureJacket;

    @FieldDisplayDefine(value = "介质（壳程）")
    private String mediumShell;

    @FieldDisplayDefine(value = "介质（管程）")
    private String mediumPipe;

    @FieldDisplayDefine(value = "介质（夹套）")
    private String mediumJacket;

    @FieldDisplayDefine(value = "主体结构型式", dictCode = "RQJG")
    private String mainStructureType;

    @FieldDisplayDefine(value = "支座型式")
    private String support;

    @FieldDisplayDefine(value = "安装型式")
    private String installation;

    @FieldDisplayDefine(value = "保温绝热方式")
    private String insulation;

    @FieldDisplayDefine(value = "无损检测方法", dictCode = "RQJCFF")
    private String checkLossless;

    @FieldDisplayDefine(value = "耐压试验种类")
    private String withstandVoltage;

    @FieldDisplayDefine(value = "泄漏试验种类")
    private String leakage;

    @FieldDisplayDefine(value = "耐压试验压力")
    private String withstandPressureTest;

    @FieldDisplayDefine(value = "泄漏试验压力")
    private String leakPressure;

    @FieldDisplayDefine(value = "容器型号")
    private String container;

    @FieldDisplayDefine(value = "罐车编号")
    private String carNum;

    @FieldDisplayDefine(value = "容积")
    private String volume;

    @FieldDisplayDefine(value = "最大充装量")
    private String maxFill;

    @FieldDisplayDefine(value = "设计压力")
    private String designPressure;

    @FieldDisplayDefine(value = "设计温度")
    private String designTemperature;

    @FieldDisplayDefine(value = "工作压力")
    private String workingPressure;

    @FieldDisplayDefine(value = "工作温度")
    private String workTemperature;

    @FieldDisplayDefine(value = "材料（筒体）")
    private String materialCylinder;

    @FieldDisplayDefine(value = "厚度（筒体）")
    private String thicknessCylinder;

    @FieldDisplayDefine(value = "腐蚀裕量")
    private String corrosionMargin;

    @FieldDisplayDefine(value = "介质")
    private String medium;

    @FieldDisplayDefine(value = "氧舱品种")
    private String oxygenChamber;

    @FieldDisplayDefine(value = "额定进舱人数")
    private Integer ratedEntryCapacity;

    @FieldDisplayDefine(value = "主体结构")
    private String chamberMain;

    @FieldDisplayDefine(value = "压力")
    private String chamberPressure;

    @FieldDisplayDefine(value = "温度")
    private String temperature;

    @FieldDisplayDefine(value = "压力介质")
    private String pressureMedium;

    @FieldDisplayDefine(value = "人均舱容")
    private String perCapitaCabinCapacity;

    @FieldDisplayDefine(value = "车辆VIN码")
    private String vin;


    @FieldDisplayDefine(value = "无损检测比例")
    private String losslessRatio;


    @FieldDisplayDefine(value = "无损检测方法")
    private String losslessMethod;


    @FieldDisplayDefine(value = "年度检查报告编号")
    private String yearReportNo;


    @FieldDisplayDefine(value = "气密性试验压力")
    private String airTightnessPressure;


    @FieldDisplayDefine(value = "气密性试验介质")
    private String airTightnessMedium;


    @FieldDisplayDefine(value = " 是否电气改造")
    private String isElectricalMod;


    @FieldDisplayDefine(value = "安全阀整定压力")
    private String setPressure;
}
