package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum BusinessTypeEnum {

    /**
     * 业务类型枚举
     */
    JG_EQUIPMENT_HANDOVER("101", "设备移交"),

    JG_INSTALLATION_NOTIFICATION("102", "安装告知"),

    JG_MODIFICATION_NOTIFICATION("103", "改造告知"),

    JG_MAINTENANCE_NOTIFICATION("104", "维修告知"),

    JG_ADVICE_REMOVAL("105", "移装告知"),

    JG_MAINTENANCE_RECORD("106", "维保合同备案"),

    JG_USAGE_REGISTRATION("107", "使用登记"),

    JG_NAME_CHANGE_REGISTRATION("108", "更名变更登记"),

    JG_COMPANY_CHANGE_REGISTRATION("109", "单位变更登记"),

    JG_CHANGE_REGISTRATION("110", "移装变更登记"),

    JG_RENOVATION_REGISTRATION("111", "改造变更登记"),

    JG_EQUIPMENT_START_STOP("112", "设备启用停用"),

    JG_EQUIPMENT_START("112-1", "设备启用"),
    JG_EQUIPMENT_STOP("112-2", "设备停用"),

    JG_EQUIPMENT_MOVE_CANCEL("113", "注销报废"),

    JG_EQUIPMENT_MOVE("113-1", "注销"),
    JG_EQUIPMENT_CANCEL("113-2", "报废"),

    JY_OPENING_APPLICATION("114", "业务开通"),

    JY_INSPECTION_APPLICATION_JD("115", "监督检验"),

    JY_INSPECTION_APPLICATION_DS("116", "定（首）检验"),

    JY_INSPECTION_APPLICATION_CHECK("117", "电梯检测"),

    JG_VEHICLE_GAS_APPLICATION("118", "车用气瓶登记"),

    JG_VEHICLE_GAS_CYLINDER_CHANGE("119", "车用气瓶变更登记"),

    JG_HISTORY_USAGE_REGISTRATION("119", "历史设备登记"),

    JG_OVER_DESIGN_SERVICE_LIFE("120", "超设计使用年限变更"),

    JG_REPLACEMENT_REGISTRATION("121", "补证登记"),

    JG_NEW_EQUIP("122", "新增设备"),

    JG_NEW_PROJECT("123", "新增装置"),

    JG_EQUIP_CLAIM("124", "设备认领");

    private final String code;

    private final String name;

    BusinessTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (BusinessTypeEnum enumOne : BusinessTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public static Optional<String> findNameByEnumName(String enumName) {
        return Arrays.stream(values())
                .filter(e -> e.name().equals(enumName))
                .map(BusinessTypeEnum::getName)
                .findFirst();
    }

}
