package com.yeejoin.amos.boot.module.jg.biz.edit;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotation.ResultFieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.context.BizDataHandleStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.controller.BizDataChangeController;
import com.yeejoin.amos.boot.module.jg.biz.edit.permission.FillingCompanyTypeForCurrentUser;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service
@RequiredArgsConstructor
public class BizDataChangeServiceImpl {

    private final BizDataHandleStrategyContext handleStrategyContext;


    /**
     * 变更保存
     *
     * @param applyNo         单据编号
     * @param bizType         业务类型
     * @param modelType       处理器类型
     * @param changeData      变化后的数据
     * @param selectedOrgInfo 登录人信息
     */
    @Transactional(rollbackFor = Exception.class)
    public void save(String bizId,
                     String applyNo,
                     String bizType,
                     IBizDataChangeHandleStrategy.ModelType modelType, RequestChangeData changeData, ReginParams selectedOrgInfo) {
        IBizDataChangeHandleStrategy handleStrategy = handleStrategyContext.getStrategy(bizType);
        handleStrategy.doSave(bizId, applyNo, modelType, changeData, selectedOrgInfo);
    }

    public IPage<?> queryDetail(String applyNo, String bizType, BizDataChangeController.DetailType type, JSONObject searchParams) {
        IBizDataChangeHandleStrategy handleStrategy = handleStrategyContext.getStrategy(bizType);
        return handleStrategy.getDetail(applyNo, type, searchParams);
    }

    @ResultFieldMapping({
            @ResultFieldMapping.ResultFieldMap(sourceField = "ESTATE_UNIT_CREDIT_CODE",
                    targetField = "ESTATE_UNIT_CREDIT_CODE",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitSeqByCreditCode",
                    secondParamValue = "CQ"
            )
    })
    public Map<String, Object> querySubDetail(String applyNo, String bizId, String bizType, BizDataChangeController.DetailType type, ReginParams selectedOrgInfo) {
        IBizDataChangeHandleStrategy handleStrategy = handleStrategyContext.getStrategy(bizType);
        // 装饰器模式增强结果
        return new FillingCompanyTypeForCurrentUser(new JSONObject(handleStrategy.getSubDetail(applyNo, bizId, type)), selectedOrgInfo.getCompany()).getData();
    }

    public IPage<?> getChangeLogPage(String bizId, String bizType, int current, int size) {
        if (bizId == null || bizId.isEmpty()) {
            return new Page<>(current, size);
        }
        IBizDataChangeHandleStrategy handleStrategy = handleStrategyContext.getStrategy(bizType);
        return handleStrategy.getChangeLogs(bizId, current, size);
    }
}
