package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.enableDisable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEnableDisable;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEnableDisableEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEnableDisableEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEnableDisableServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class EnableDisableEditUpdateService {

    private final JgEnableDisableServiceImpl enableDisableService;

    private final JgEnableDisableEqServiceImpl enableDisableEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgEnableDisable enableDisableServiceOne = enableDisableService.getOne(new LambdaQueryWrapper<JgEnableDisable>().eq(JgEnableDisable::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgEnableDisableEq> eqs = enableDisableEqService.list(new LambdaQueryWrapper<JgEnableDisableEq>().eq(JgEnableDisableEq::getEnableDisableApplyId, enableDisableServiceOne.getSequenceNbr()).select(JgEnableDisableEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgEnableDisableEq::getEquId).collect(Collectors.toSet());
    }

    public JgEnableDisable getOneByApplyNo(String applyNo) {
        return enableDisableService.getOne(new LambdaQueryWrapper<JgEnableDisable>().eq(JgEnableDisable::getApplyNo, applyNo));
    }

}