package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgReformNoticeMapper;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class ReformNoticeEquipUsedCheckImpl extends BaseEquipUsedCheckService {

    private final RedissonClient redissonClient;

    private final String bizType = "renovationNoticeNew";

    private final JgReformNoticeMapper reformNoticeMapper;

    public ReformNoticeEquipUsedCheckImpl(RedissonClient redissonClient, JgReformNoticeMapper reformNoticeMapper) {
        this.redissonClient = redissonClient;
        this.reformNoticeMapper = reformNoticeMapper;
    }


    @Override
    public RedissonClient getRedisClient() {
        return redissonClient;
    }

    @Override
    public String getApplyBizType() {
        return bizType;
    }


    @Override
    public void init() {
        // 初始化已经完成或者在流程中安装告知的设备数据
        List<CompanyEquipCountDto> companyEquipCountDtos = reformNoticeMapper.queryForFlowingEquipList();
        companyEquipCountDtos.remove(null);
        companyEquipCountDtos.forEach(c -> {
            RBucket<Set<String>> rBucket = redissonClient.getBucket(getFlowingEquipRedisKey(c.getCompanyCode(), bizType));
            rBucket.set(Arrays.stream(c.getRecords().split(",")).collect(Collectors.toSet()));
        });
    }
}
