package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class EquListConverter implements Converter<String> {

    public static final Map<String, String> equipmentMap = new HashMap<>();
    public static final Map<String, String> reverseEquipmentMap = new HashMap<>();
    static {
        // 填充映射关系
        equipmentMap.put("起重机械", "4000");
        equipmentMap.put("场内机动车辆", "5000");
        equipmentMap.put("锅炉", "1000");
        equipmentMap.put("压力容器", "2000");
        equipmentMap.put("压力管道", "8000");
        equipmentMap.put("大型游乐设施", "6000");
        equipmentMap.put("客运索道", "9000");
        equipmentMap.put("电梯", "3000");
        equipmentMap.forEach((key, value) -> reverseEquipmentMap.put(value, key));
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return equipmentMap.getOrDefault(cellValue, null);
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }
}
