package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
/**
* 消防员合同
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters_contract")
@ApiModel(value="FirefightersContract对象", description="消防员合同")
public class FirefightersContract extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "合同名称")
    private String name;

    @ApiModelProperty(value = "甲方")
    private String partyA;

    @ApiModelProperty(value = "乙方")
    private String partyB;

    @ApiModelProperty(value = "签订日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date signedTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "到期时间")
    private Date expireTime;

    @ApiModelProperty(value = "服务内容")
    private String serviceContent;

    @ApiModelProperty(value = "合同附件")
    private String attachment;

    @ApiModelProperty(value = "合同类型")
    private String contractType;
    @ApiModelProperty(value = "合同类型字典code")
    private String contractTypeCode;
    
    @ApiModelProperty(value = "人员id")
    private Long firefightersId;
    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;
}
