package com.yeejoin.amos.boot.module.common.api.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;




/**
 * 机构/部门/人员表 服务类
 *
 * @author tb
 * @date 2021-06-18
 */
public interface IOrgUsrService {
	/**
	 * 查询上级单位
	 * @param parent_id
	 * @return
	 */
    String selectUpUnitByParam(String parent_id);

	/**
	 * 获取父级
	 * @param topId
	 * @param entityList
	 * @param packageURL
	 * @param IDMethodName
	 * @param IDHierarchy
	 * @param NAMEMethodName
	 * @param PARENTIDMethodName
	 * @param OrgTypeMethodName
	 * @return
	 * @throws Exception
	 */
	List<OrgMenuDto> getTree(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy,
							String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

	/**
	 * 获取子数据集合
	 * @param topId
	 * @param entityList
	 * @param packageURL
	 * @param IDMethodName
	 * @param IDHierarchy
	 * @param NAMEMethodName
	 * @param PARENTIDMethodName
	 * @param OrgTypeMethodName
	 * @return
	 * @throws Exception
	 */
	List<OrgMenuDto> getSub(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy,
			String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

	/**
	 * 组装融合调度单位人员信息
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	List<Map<String, Object>> returnCompanyPersonMsg(List<Long> ids) throws Exception;

	/**
	 * 获取动态表单数据
	 * @param  id
	 * @return
	 * @throws Exception
	 */
	List<FormValue> getFormValue(Long id) throws Exception;

	/**
	 * 保存 机构/部门/人员基本信息
	 * @param
	 * @throws Exception
	 */
	void saveOrgUsr (OrgUsr orgUsr, OrgUsr oriOrgUsr) throws Exception;

	/**
	 * 新增机构/部门/人员基本信息和动态表单数据
	 * @param orgUsr
	 * @param alertFromValuelist
	 */
	void saveOrgUsrDynamicFormInstance (OrgUsr orgUsr,List<DynamicFormInstance> alertFromValuelist)throws Exception;

	/**
	 * 更新机构/部门/人员基本信息和动态表单数据
	 *
	 * @param instanceId 实例id
	 * @param fromValueList 动态表单数据列表
	 * @throws Exception
	 */
	void updateDynamicFormInstance(Long instanceId, List<DynamicFormInstance> fromValueList)throws Exception;

	/**
	 *
	 * @param id
	 * @throws Exception
	 */
	Map<String, Object> selectForShowById (OrgUsr orgUsr,Long id) throws Exception;

	List<OrgUsr> selectCompanyDepartmentMsg();

	void saveOrgUsr( OrgUsrDto OrgUsrDto) throws Exception;

	void saveOrgPerson( OrgPersonDto OrgPersonDto) throws Exception;

	void updateByIdOrgUsr(OrgUsrDto OrgUsrDto,Long id) throws Exception;

	void updateByIdOrgPerson(OrgPersonDto OrgPersonDto,Long id) throws Exception;

	OrgUsrFormDto selectCompanyById(Long id) throws Exception;

	IPage bizOrgTypeListPage(String pageNum, String pageSize, String bizOrgType) throws Exception;

	void saveDepartment(List<OrgDepartmentDto> OrgDepartmentDto, Long id)throws Exception;

	void saveCompany(List<OrgUsrDto> OrgUsrDto)throws Exception;

	OrgPersonFormDto selectPersonById(Long id) throws Exception;

	OrgPersonFormDto selectPersonByIdDetail(Long id) throws Exception;

	List<OrgMenuDto> selectPersonTree() throws Exception;

	void savePersonList (List <OrgPersonDto> OrgPersonDto)throws Exception;

	void saveOrgDepartment(OrgDepartmentDto OrgDepartmentDto) throws Exception;

	void updateByIdOrgDepartment ( OrgDepartmentDto OrgDepartmentDto,Long id) throws Exception;

	OrgDepartmentFormDto selectDepartmentById(Long id) throws Exception;

	List<Map<String, Object>>  selectForShowByListId(List<Long> ids) throws Exception;


	/**
	 * * @param null
	 * @return
	 * <PRE>
	 * author tw
	 * date 2021/7/20
	 * </PRE>
	 * 列表
	 */
	List<CompanyDto> listContractDto(Integer pageNum, Integer pageSize, RequestData requestData);
	/**
	 * * @param null
	 * @return
	 * <PRE>
	 * author tw
	 * date 2021/7/20
	 * </PRE>
	 * 统计
	 */
	Integer listContractDtoCount(RequestData par);

     /**
      * * @param null
      * @return
      * <PRE>
      * author tw
      * date 2021/7/26
      * </PRE>
      */

	List<OrgUsrzhDto> getOrgUsrzhDto(String  name);
	
	
	List<ESOrgUsrDto> selectByIddata(String name);
}
