package com.yeejoin.amos.maintenance.dao.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the p_check database table.
 * 
 */
@Entity
@Table(name="p_check")
@NamedQuery(name="Check.findAll", query="SELECT c FROM Check c")

public class Check extends BasicEntity {

	private static final long serialVersionUID = 1L;


	

	/**
	 * 参考地址
	 */
	@Column(name="address")
	private String address;

	/**
	 * 巡检方式
	 */
	@Column(name="check_mode")
	private String checkMode="";

	/**
	 * 检查时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="check_time")
	private Date checkTime;

	/**
	 * 设备编号
	 */
	@Column(name="device_id")
	private String deviceId;

	

	/**
	 * 不合格项目
	 */
	private String error;

	/**
	 * 是否合格
	 */
	@Column(name="is_ok")
	private String isOk;

	/**
	 * 经度
	 */
	private String latitude;

	/**
	 * 纬度
	 */
	private String longitude;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 计划编号
	 */
	@Column(name="plan_id")
	private Long planId;
	
	/**
	 * 线路名称
	 */
	@Column(name="plan_name")
	private String planName;

	/**
	 * 计划执行编号
	 */
	@Column(name="plan_task_id")
	private Long planTaskId;
	
	/**
	 * 执行计划详情id
	 */
	@Column(name="plan_task_detail_id")
	private Long planTaskDetailId;

	/**
	 * 巡检点id
	 */
	@Column(name="point_id")
	private Long pointId;
	
	/**
	 * 点名称
	 */
	@Column(name="point_name")
	private String pointName;

	/**
	 * 巡检备注说明
	 */
	private String remark;

	/**
	 * 路线编号
	 */
	@Column(name="route_id")
	private Long routeId;
	
	/**
	 * 路线名称
	 */
	@Column(name="route_name")
	private String routeName;

	/**
	 * 评分
	 */
	private int score;

	/**
	 * 拍照数量
	 */
	@Column(name="shot_number")
	private int shotNumber;

	/**
	 * 记录上传时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="upload_time")
	private Date uploadTime;

	/**
	 * 巡检人ids
	 */
	@Column(name="user_id")
	private String userId;
	
	/**
	 * 执行人名称
	 */
	@Column(name="user_name")
	private String userName;
	
	/**
	 * 执行部门ids
	 */
	@Column(name="dep_id")
	private String depId;
	/**
	 * 执行部门名称
	 */
	@Column(name="dep_name")
	private String depName;
	
	@Column(name="error_classify")
	private String errorClassify;
	
	private List<CheckInput> checkInput;

	private List<CheckShot> checkShot;

	public Check() {
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getDepId() {
		return depId;
	}

	public void setDepId(String depId) {
		this.depId = depId;
	}

	public String getDepName() {
		return depName;
	}

	public void setDepName(String depName) {
		this.depName = depName;
	}

	public long getPlanTaskDetailId() {
		return planTaskDetailId;
	}

	public void setPlanTaskDetailId(long planTaskDetailId) {
		this.planTaskDetailId = planTaskDetailId;
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getCheckMode() {
		return this.checkMode;
	}

	public void setCheckMode(String checkMode) {
		this.checkMode = checkMode;
	}

	public Date getCheckTime() {
		return this.checkTime;
	}

	public void setCheckTime(Date checkTime) {
		this.checkTime = checkTime;
	}

	public String getDeviceId() {
		return this.deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getError() {
		return this.error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public String getIsOk() {
		return this.isOk;
	}

	public void setIsOk(String isOk) {
		this.isOk = isOk;
	}

	public String getLatitude() {
		return this.latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLongitude() {
		return this.longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public long getPlanId() {
		return this.planId;
	}

	public void setPlanId(long planId) {
		this.planId = planId;
	}

	public long getPlanTaskId() {
		return this.planTaskId;
	}

	public void setPlanTaskId(long planTaskId) {
		this.planTaskId = planTaskId;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public long getRouteId() {
		return this.routeId;
	}

	public void setRouteId(long routeId) {
		this.routeId = routeId;
	}

	public int getScore() {
		return this.score;
	}

	public void setScore(int score) {
		this.score = score;
	}

	public int getShotNumber() {
		return this.shotNumber;
	}

	public void setShotNumber(int shotNumber) {
		this.shotNumber = shotNumber;
	}

	public Date getUploadTime() {
		return this.uploadTime;
	}

	public void setUploadTime(Date uploadTime) {
		this.uploadTime = uploadTime;
	}


	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getErrorClassify() {
		return errorClassify;
	}

	public void setErrorClassify(String errorClassify) {
		this.errorClassify = errorClassify;
	}

	@OneToMany(mappedBy = "check", cascade = {CascadeType.REMOVE,CascadeType.MERGE,CascadeType.PERSIST })
	public List<CheckInput> getCheckInput() {
		return checkInput;
	}

	public void setCheckInput(List<CheckInput > checkInput) {
		this.checkInput = checkInput;
	}
	@OneToMany(mappedBy = "check", cascade = {CascadeType.REMOVE,CascadeType.MERGE,CascadeType.PERSIST })
	public List<CheckShot> getCheckShot() {
		return checkShot;
	}

	public void setCheckShot(List<CheckShot> checkShot) {
		this.checkShot = checkShot;
	}
	
	public String getPlanName() {
		return planName;
	}

	public void setPlanName(String planName) {
		this.planName = planName;
	}

	public String getPointName() {
		return pointName;
	}

	public void setPointName(String pointName) {
		this.pointName = pointName;
	}

	public String getRouteName() {
		return routeName;
	}

	public void setRouteName(String routeName) {
		this.routeName = routeName;
	}

}