package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureDetailsServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
/*import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;*/
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2021-08-04
 */
@RestController
@Api(tags = "故障维修单Api")
@RequestMapping(value = "/common/failure-details")
public class FailureDetailsController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(FailureDetailsServiceImpl.class);

    @Autowired
    FailureDetailsServiceImpl failureDetailsServiceImpl;

    /**
     * 新增
     *
     * @return
     */
/*
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public CommonResponse save(@RequestBody FailureDetailsDto model) {
	  */
/*  model = failureDetailsServiceImpl.savemodel(model);
	    return ResponseHelper.buildResponse(model);*//*


		CommonResponse commonResponse = new CommonResponse();
		try {
			AgencyUserModel user = getUserInfo();
			if (ObjectUtils.isEmpty(user)) {
				return CommonResponseUtil.failure("用户session过期");
			}
			return failureDetailsServiceImpl.savemodel(model);
		} catch (Exception e) {
			logger.error("", e.getMessage());
			return CommonResponseUtil.failure("系统繁忙，请稍后再试");
		}
	}
*/

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<FailureDetailsDto> updateBySequenceNbrFailureDetails(@RequestBody FailureDetailsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<FailureDetailsDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<FailureDetailsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FailureDetailsDto> page = new Page<FailureDetailsDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureDetailsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FailureDetailsDto>> selectForList() {
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureDetailsList());
	}

	/**
	 * 根据状态查询当前下全部数据
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据状态查询当前下全部数据",   notes = "根据状态查询当前下全部数据")
	@GetMapping(value = "/list/{currentStatus}")
	public ResponseModel<List<FailureDetails>> selectStatusForList(@PathVariable Long currentStatus) {

		return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureDetailsList(currentStatus));
	}


}
