package com.yeejoin.amos.boot.module.common.biz.service.impl;


import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureDetailsMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureDetailsService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureDetailsServiceImpl extends BaseService<FailureDetailsDto, FailureDetails, FailureDetailsMapper> implements IFailureDetailsService {


    @Autowired
    SourceFileServiceImpl sourceFileServiceImpl;
 
//    @Autowired
//	RemoteWorkFlowService remoteWorkFlowService;
//    
//    @Value("${failure.work.flow.processDefinitionKey}")
//    private String processDefinitionKey;

    private final Logger logger = LoggerFactory.getLogger(FailureDetailsServiceImpl.class);


    /**
     * 分页查询
     */
    public Page<FailureDetailsDto> queryForFailureDetailsPage(Page<FailureDetailsDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FailureDetailsDto> queryForFailureDetailsList() {
        return this.queryForList("", false);
    }

    /**
     * 根据状态查询
     */
    public List<FailureDetails> queryForFailureDetailsList(Long currentStatus) {
        QueryWrapper<FailureDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("current_status",currentStatus).orderByDesc("submission_time");
        return baseMapper.selectList(queryWrapper);

    }

    /**
     * 发起故障保修单
     */
//       public Object savemodel(FailureDetailsDto failureDetailsDto) {
//    	 String businessKey = buildOrderNo();
//        JSONObject jsonObject = remoteWorkFlowService.start( businessKey, processDefinitionKey);
//        if (jsonObject == null) {
//            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//           // return CommonResponseUtil.failure("启动流程失败");
//        }
//        JSONObject instance = jsonObject.getJSONObject("data");
//        if(instance==null){
//            //return CommonResponseUtil.failure("无提交隐患权限");
//        }
//        failureDetailsDto.setCurrentStatus(FailureStatuEnum.WAITING_AUDIT.getCode());
//        //拿到流程id
//        failureDetailsDto.setProcessId(instance.getString("processInstanceId"));
//        FailureDetailsDto model =null;
//        try {
//             sourceFileServiceImpl.saveSourceFile(failureDetailsDto.getSequenceNbr(), failureDetailsDto.getAttachment());
//             model = this.createWithModel(failureDetailsDto);
//		} catch (Exception e) {
//			logger.info("添加故障维修信息到数据库失败");
//			// return CommonResponseUtil.failure("添加失败");
//		}
//        if(ObjectUtils.isNotEmpty(model)) {
//        	JSONObject  teskObject = remoteWorkFlowService.currentTask(instance.getString("processInstanceId"));
//        	if(ObjectUtils.isNotEmpty(teskObject)) {
//        		 JSONObject taskDetail = teskObject.getJSONObject("data");
//        		 String taskId = taskDetail.getString("id");
//        		 remoteWorkFlowService.excute(taskId, null);
//        	}
//        }
//        return model;
//    }
//       public static String buildOrderNo() {
//           SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
//           String newDate = sdf.format(new Date());
//           String result = "";
//           Random random = new Random();
//           for (int i = 0; i < 3; i++) {
//               result += random.nextInt(10);
//           }
//           return newDate + result;
//       }
}