package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.ExcelDto;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ExcelServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletResponse;

/**
 * 导出导入
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Api(tags = "导出")
@RequestMapping(value = "/excel")
public class ExcelController extends BaseController {

    @Autowired
    ExcelServiceImpl excelService;

    private static final String NOT_DUTY = "休班";

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/template")
    public void template(HttpServletResponse response, ExcelDto excelDto) {
        try {
            excelService.templateExport(response, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/download/template")
    public void downloadTemplate(HttpServletResponse response, @RequestParam(required = false) String fileName,
                                 @RequestParam(required = false) String sheetName, @RequestParam String classUrl) {
        try {
            ExcelDto excelDto = new ExcelDto(fileName, sheetName, classUrl, toString());
            excelService.templateExport(response, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出公用类")
    @GetMapping("/export")
    public void getFireStationFile(HttpServletResponse response, ExcelDto excelDto) {
        try {
            excelService.commonExport(response, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出公用类2")
    @GetMapping("/export/list")
    public void exportByType(HttpServletResponse response, @RequestParam(required = false) String fileName,
                             @RequestParam(required = false) String sheetName, @RequestParam String type) {
        try {
            excelService.commonExport(response, new ExcelDto(fileName, sheetName, type));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "上传文件数据-")
    @PostMapping("/upload")
    public void upload(@RequestPart("file") MultipartFile multipartFile, ExcelDto excelDto) {
        try {
            excelService.commonUpload(multipartFile, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "上传文件数据-2")
    @PostMapping("/upload2")
    public void upload2(@RequestPart("file") MultipartFile multipartFile,
                        @RequestParam(required = false) String fileName,
                        @RequestParam(required = false) String sheetName,
                        @RequestParam String type) {
        try {
            excelService.commonUpload(multipartFile, new ExcelDto(fileName, sheetName, type));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    /**
     * 导出值班模板
     *
     * @param response
     * @param beginDate 值班开始日期
     * @param endDate   值班结束日期
     * @param excelDto  导出类型参数
     * @param ids       部门或队伍的id列表，逗号分隔
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出值班模板", notes = "导出值班模板")
    @GetMapping(value = "/duty_template")
    public void dutyCarTemplate(HttpServletResponse response, @RequestParam("beginDate") String beginDate,
                                @RequestParam("endDate") String endDate, ExcelDto excelDto,
                                @RequestParam("ids") String ids) {
        try {
            excelService.dutyTemplateExport(response, beginDate, endDate, excelDto, ids);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出值班信息", notes = "导出值班模板")
    @GetMapping(value = "/duty_info")
    public void dutyCarDuty(HttpServletResponse response, @RequestParam("beginDate") String beginDate,
                            @RequestParam("endDate") String endDate, ExcelDto excelDto) {
        try {
            excelService.dutyInfoExport(response, beginDate, endDate, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }
}
