package com.yeejoin.amos.maintenance.business.controller;

import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.param.CheckStatsListPageParam;
import com.yeejoin.amos.maintenance.business.service.intfc.IQueryStatsService;
import com.yeejoin.amos.maintenance.business.util.CheckStatsParamUtils;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.business.vo.CheckStatsVo;
import com.yeejoin.amos.maintenance.core.common.request.CommonPageable;
import com.yeejoin.amos.maintenance.core.common.request.CommonRequest;
import com.yeejoin.amos.maintenance.core.framework.Permission;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/stats")
@Api(tags="巡检查询统计api")
public class QueryStatsController extends AbstractBaseController {
	
	@Autowired
	private IQueryStatsService iQueryStatsService;
	
	/**
	 * 查询巡检统计信息
	 * 
	 * @param point
	 * @return
	 */
	@Permission
	@ApiOperation(value = "查询巡检点信息", notes = "查询巡检点信息")
	@PostMapping(value = "/checkStats", produces = "application/json;charset=UTF-8")
	public CommonResponse queryCheckStats(
			@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
		ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        HashMap<String, Object> paramMap = buildMybatisDaoCriterias(loginOrgCode, roleTypeName);
		CheckStatsListPageParam param = CheckStatsParamUtils.fillCheckInfoParam(queryRequests, commonPageable, paramMap);
		Page<CheckStatsVo> dataList = iQueryStatsService.queryCheckStats(param);
		return CommonResponseUtil.success(dataList);
	}
}
