package com.yeejoin.amos.maintenance.business.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.core.framework.Permission;
import com.yeejoin.amos.maintenance.feign.RemoteSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/safe")
@Api(tags="公司选择api")
public class SafetyController extends AbstractBaseController{
	private final Logger log = LoggerFactory.getLogger(SafetyController.class);
	/**
	 * 保存登陆用户选择公司信息
	 * @return
	 *//*
	@ApiOperation(value = "  保存登陆用户选择公司信息", notes = " 保存登陆用户选择公司信息")
	@RequestMapping(value = "/save/curCompany/{orgCode}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse getCompanysInfo(
			@ApiParam(value = "当前登陆用户所选单位信息", required = true) @PathVariable String orgCode) {
		LoginUserParam param = new LoginUserParam();
		User user = getUserInfo();
		log.info("分类---->"+user.getRole().getRoleTypeName());
		param.setLoginOrgCode(orgCode);//当前登陆用户所选单位信息
		param.setUserOrgCode(user.getOrgCode());//登录用户的orgCode
		param.setRoleId(user.getRole().getId().toString());//登录用户角色	
		param.setRoleTypeName(user.getRole().getRoleTypeName());
		param.setUserId(user.getId());
		if(user.getDepartment() != null){
			param.setDepartmentId(user.getDepartment().getId());
		}
		CurUserCompanyCache.getInstance().putCurCompanyMap(getUserId(), getToken(),param);
		return CommonResponseUtil.success();
	}*/
	
	/*@Autowired
	private AmosBankFeign pointService;*/

	@Autowired
    private RemoteSecurityService remoteSecurityService;
	
	 /**
     * 保存登陆用户选择公司信息
     */
	@Permission
    @ApiOperation(value = "  保存登陆用户选择公司信息", notes = " 保存登陆用户选择公司信息")
    @PostMapping(value = "/save/curCompany")
    public CommonResponse saveCurCompany(@RequestBody ReginParams reginParams) {
        this.saveSelectedOrgInfo(reginParams);
        // CatalogTree  hh4= new CatalogTree();
       // CommonResponse  hh= pointService.pushSpcCheckResult(hh4);
        
        return CommonResponseUtil.success();
    }

    /**
     * 保存登陆用户选择公司信息（换流站项目登录巡检）
     */
	@Permission
    @ApiOperation(value = "保存登陆用户选择公司信息", notes = "保存登陆用户选择公司信息")
    @GetMapping(value = "/save/shortCutCompany")
    public CommonResponse specialSaveCurCompany(
            @ApiParam(value = "token", required = true) @RequestParam String token,
            @ApiParam(value = "公司ID", required = true) @RequestParam Long companyId,
            @ApiParam(value = "部门ID", required = true) @RequestParam Long deptId,
            @ApiParam(value = "角色ID", required = true) @RequestParam Long roleId) {

//        AgencyUserModel agencyUserModel = remoteSecurityService.getAgencyUserModel(token);
//        List<CompanyModel> companys = agencyUserModel.getCompanys();
//        Map<Long, List<DepartmentModel>> companyDepartments = agencyUserModel.getCompanyDepartments();
//        Map<Long, List<RoleModel>> orgRoles = agencyUserModel.getOrgRoles();
//
//        CompanyModel companyModel = companys.stream().filter(x->x.getSequenceNbr().equals(companyId)).findFirst().get();
//        List<DepartmentModel> departmentModelList = companyDepartments.get(companyId);
//        DepartmentModel departmentModel = departmentModelList.stream().filter(x->x.getSequenceNbr().equals(deptId)).findFirst().get();
//        List<RoleModel> roleModelList = orgRoles.get(deptId);
//        RoleModel roleModel = roleModelList.stream().filter(x->x.getSequenceNbr().equals(roleId)).findFirst().get();
//        ReginParams reginParams = new ReginParams();
//        CompanyBo company = new CompanyBo();
//        DepartmentBo department = new DepartmentBo();
//        RoleBo role = new RoleBo();
//        BeanCopierUtil.copyProperties(companyModel, company);
//        company.setSequenceNbr(companyModel.getSequenceNbr().toString());
//        if (ObjectUtils.isEmpty(companyModel.getParentId())){ company.setParentId(companyModel.getParentId().toString()); }
//        BeanCopierUtil.copyProperties(departmentModel, department);
//        department.setSequenceNbr(departmentModel.getSequenceNbr().toString());
//        if (ObjectUtils.isEmpty(departmentModel.getParentId())){ department.setParentId(departmentModel.getParentId().toString()); }
//        BeanCopierUtil.copyProperties(roleModel, role);
//        role.setSequenceNbr(roleModel.getSequenceNbr().toString());
//
//        reginParams.setCompany(company);
//        reginParams.setDepartment(department);
//        reginParams.setRole(role);
//        this.saveSelectedOrgInfo(reginParams);

        return CommonResponseUtil.success();
    }
}
