package com.yeejoin.amos.maintenance.business.entity.mybatis;

import lombok.Data;

import java.util.Date;

/**
 * 风险研判任务表
 */
@Data
public class RiskJudgmentTaskBo {

    /**
     * 主键自增
     */
    private Long id;

    /**
     * 风险研判名称
     */
    private String taskName;

    /**
     * 部门编号
     */
    private String departmentId;

    /**
     * 状态（0：未开始；1：进行中；2：已超时；3：已提交）
     */
    private Integer taskStatus;

    /**
     * 风险研判日期（今天8:00-明天8:00）
     */
    private Date taskDate;

    /**
     * 提交时间
     */
    private Date taskCommitDate;

    private String currentFlowTaskId;

    private String taskDefinitionKey;

    /**
     * 可执行用户（多个逗号隔开）
     */
    private String flowUserIds;
    
    /**
     * 业务唯一标识
     */
    private String businessKey;


    /**
     * 工作流实例编号
     */
    private String flowInstanceId;

    private String orgCode;

    /**
     * 是否删除（0：否；1：是）
     */
    private Integer deleted;

    /**
     * 记录创建时间
     */
    private Date createDate;

    /**
     * 记录修改时间
     */
    private Date updateDate;
}
