package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tzs.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.VoiceRecordFileServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "通话记录附件Api")
@RequestMapping(value = "/tzs/voice-record-file")
public class VoiceRecordFileController extends BaseController {

    @Autowired
    VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    /**
     * 新增通话记录附件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增通话记录附件", notes = "新增通话记录附件")
	public ResponseModel<VoiceRecordFileDto> save(@RequestBody VoiceRecordFileDto model) {
	    model = voiceRecordFileServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新通话记录附件", notes = "根据sequenceNbr更新通话记录附件")
	public ResponseModel<VoiceRecordFileDto> updateBySequenceNbrVoiceRecordFile(@RequestBody VoiceRecordFileDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除通话记录附件", notes = "根据sequenceNbr删除通话记录附件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个通话记录附件",  notes = "根据sequenceNbr查询单个通话记录附件")
	public ResponseModel<VoiceRecordFileDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "通话记录附件分页查询",  notes = "通话记录附件分页查询")
	public ResponseModel<Page<VoiceRecordFileDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<VoiceRecordFileDto> page = new Page<VoiceRecordFileDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.queryForVoiceRecordFilePage(page));
	}

	/**
	 * 根据警情id 查找通话记录信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找通话记录信息",   notes = "根据警情id 查找通话记录信息")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<VoiceRecordFile>> selectForListByAlertId(@PathVariable Long alertId) {
		QueryWrapper<VoiceRecordFile> queryWrapper = new QueryWrapper<VoiceRecordFile>();
		queryWrapper.eq("alert_id", alertId).orderByDesc("rec_date");
		List<VoiceRecordFile> list = voiceRecordFileServiceImpl.list(queryWrapper);
		return ResponseHelper.buildResponse(list);
	}
}
